/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws;

import com.dbeaver.cloud.aws.AWSCloud;
import com.dbeaver.cloud.aws.AWSCloudAbstractInstance;
import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.AWSCloudZone;
import com.dbeaver.cloud.aws.AWSDatabaseEngine;
import com.dbeaver.cloud.aws.athena.AWSCloudAthenaEndpoint;
import com.dbeaver.cloud.aws.documentdb.AWSCloudDocumentDBCluster;
import com.dbeaver.cloud.aws.dsql.AWSCloudDsqlCluster;
import com.dbeaver.cloud.aws.dynamodb.AWSCloudDynamoDBEndpoint;
import com.dbeaver.cloud.aws.elasticache.AWSCloudElasticacheRedisCluster;
import com.dbeaver.cloud.aws.keyspaces.AWSCloudKeyspacesEndpoint;
import com.dbeaver.cloud.aws.neptune.AWSCloudNeptuneEndpoint;
import com.dbeaver.cloud.aws.rds.AWSCloudRdsInstance;
import com.dbeaver.cloud.aws.redshift.AWSCloudRedshiftCluster;
import com.dbeaver.cloud.aws.redshift.AWSCloudRedshiftServerlessCluster;
import com.dbeaver.cloud.aws.timestream.AWSCloudTimestreamDatabase;
import com.dbeaver.cloud.model.CPCloudExplorer;
import com.dbeaver.cloud.model.CPCloudSession;
import com.dbeaver.cloud.model.services.CPDatabaseFolder;
import com.dbeaver.net.auth.aws.AWSIAMUtils;
import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.docdb.DocDbClient;
import software.amazon.awssdk.services.docdb.model.DBCluster;
import software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClustersResponse;
import software.amazon.awssdk.services.dsql.DsqlClient;
import software.amazon.awssdk.services.dsql.model.ClusterSummary;
import software.amazon.awssdk.services.dsql.model.GetClusterRequest;
import software.amazon.awssdk.services.dsql.model.GetClusterResponse;
import software.amazon.awssdk.services.dsql.model.ListClustersRequest;
import software.amazon.awssdk.services.dsql.model.ListClustersResponse;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.dynamodb.model.Endpoint;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.CacheCluster;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersResponse;
import software.amazon.awssdk.services.neptune.NeptuneClient;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DBInstance;
import software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.Cluster;
import software.amazon.awssdk.services.redshift.model.ClusterNotFoundException;
import software.amazon.awssdk.services.redshift.model.DescribeClustersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClustersResponse;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessClient;
import software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.Workgroup;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse;
import software.amazon.awssdk.services.timestreamwrite.TimestreamWriteClient;
import software.amazon.awssdk.services.timestreamwrite.model.Database;
import software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesResponse;

public class AWSCloudExplorer
implements CPCloudExplorer<AWSCloudZone> {
    private static final Log log = Log.getLog(AWSCloudExplorer.class);
    @NotNull
    private final AWSCloud cloud;
    @NotNull
    private AWSCloudSession session;
    private GetCallerIdentityResponse callerIdentity;

    public AWSCloudExplorer(@NotNull AWSCloud cloud, @NotNull AWSCloudSession session) {
        this.cloud = cloud;
        this.session = session;
    }

    @NotNull
    public AWSCloud getCloud() {
        return this.cloud;
    }

    @NotNull
    public CPDatabaseFolder[] getRootFolders(@NotNull DBRProgressMonitor monitor) {
        return new CPDatabaseFolder[0];
    }

    @NotNull
    public AWSCloudAbstractInstance[] getDatabaseInstances(@NotNull DBRProgressMonitor monitor, @NotNull String serviceID, @Nullable CPDatabaseFolder category) throws DBException {
        log.debug((Object)("[" + this.session.getSessionId() + "] Explore AWS zones: " + Arrays.toString(this.session.getDefaultZones())));
        try {
            monitor.subTask("Read STS user ID");
            AWSIAMUtils.tryExecuteRecover((DBRProgressMonitor)monitor, (AuthModelAWSCredentials)this.session.getIamCredentials(), () -> {
                this.callerIdentity = this.cloud.readGetCallerIdentity(monitor, this.session);
                return this.callerIdentity;
            });
            monitor.worked(1);
            ArrayList<AWSCloudAthenaEndpoint> instances = new ArrayList<AWSCloudAthenaEndpoint>();
            DBException lastError = null;
            AWSCloudZone[] aWSCloudZoneArray = this.session.getDefaultZones();
            int n = aWSCloudZoneArray.length;
            int n2 = 0;
            while (n2 < n) {
                AWSCloudZone zone = aWSCloudZoneArray[n2];
                try {
                    List<AWSCloudAbstractInstance> regionInstances = switch (serviceID) {
                        case "rds" -> this.findRdsInstances(monitor, this.session, zone);
                        case "redshift" -> this.findRedshiftInstances(monitor, this.session, zone);
                        case "documentdb" -> this.findDocumentDBInstances(monitor, this.session, zone);
                        case "keyspaces" -> this.findKeyspacesInstances(monitor, this.session, zone);
                        case "dynamodb" -> this.findDynamoDBInstances(monitor, this.session, zone);
                        case "athena" -> this.findAthenaInstances(monitor, this.session, zone);
                        case "elasticache" -> this.findRedisInstances(monitor, this.session, zone);
                        case "neptune" -> this.findNeptuneInstances(monitor, this.session, zone);
                        case "timestream" -> this.findTimestreamDatabases(monitor, this.session, zone);
                        case "dsql" -> this.findDsqlClusters(monitor, this.session, zone);
                        default -> throw new DBException("Service '" + serviceID + "' not supported yet");
                    };
                    instances.addAll(regionInstances);
                }
                catch (Exception e) {
                    lastError = new DBException("Error loading " + serviceID + " instances in " + zone.getZoneId(), (Throwable)e);
                }
                ++n2;
            }
            if (lastError != null) {
                if (instances.isEmpty()) {
                    throw lastError;
                }
                log.error(lastError);
            }
            return instances.toArray(new AWSCloudAbstractInstance[0]);
        }
        catch (Exception e) {
            throw new DBException("Error reading AWS instances", (Throwable)e);
        }
    }

    public AWSCloudAbstractInstance getDatabaseInstance(@NotNull DBRProgressMonitor monitor, @NotNull String serviceID, @Nullable CPDatabaseFolder category, @NotNull AWSCloudZone zone, @NotNull String instanceId) throws DBException {
        monitor.subTask("Read STS user ID");
        this.callerIdentity = this.cloud.readGetCallerIdentity(monitor, this.session);
        monitor.worked(1);
        return switch (serviceID) {
            case "rds" -> this.findRdsInstance(monitor, this.session, zone, instanceId);
            case "redshift" -> this.findRedshiftInstance(monitor, this.session, zone, instanceId);
            case "documentdb" -> this.findDocumentDBInstance(monitor, this.session, zone, instanceId);
            case "keyspaces" -> this.findKeyspacesInstance(monitor, this.session, zone);
            case "dynamodb" -> this.findDynamoDBInstance(monitor, this.session, zone);
            case "athena" -> this.findAthenaInstance(monitor, this.session, zone);
            case "elasticache" -> this.findRedisInstance(monitor, this.session, zone, instanceId);
            case "neptune" -> this.findNeptuneInstance(monitor, this.session, zone, instanceId);
            case "timestream" -> this.findTimestreamDatabase(monitor, this.session, zone, instanceId);
            case "dsql" -> this.findDsqlCluster(monitor, this.session, zone, instanceId);
            default -> throw new DBException("Service '" + serviceID + "' not supported yet");
        };
    }

    public void refreshSession(@NotNull CPCloudSession<AWSCloudZone> cloudSession) {
        this.session = (AWSCloudSession)cloudSession;
    }

    private List<AWSCloudRdsInstance> findRdsInstances(@NotNull DBRProgressMonitor monitor, @NotNull AWSCloudSession session, @NotNull AWSCloudZone zone) throws DBException {
        monitor.subTask("Describe RDS instances");
        Set supportedEngineIds = Arrays.stream(AWSCloudRdsInstance.SUPPORTED_RDS_ENGINES).map(AWSDatabaseEngine::getEngineId).collect(Collectors.toSet());
        Throwable throwable = null;
        Object var6_7 = null;
        try (RdsClient rdsClient = (RdsClient)this.configureClient(monitor, RdsClient.builder(), session, zone).build();){
            DescribeDbInstancesResponse instancesResponse = rdsClient.describeDBInstances();
            ArrayList<AWSCloudRdsInstance> instances = new ArrayList<AWSCloudRdsInstance>();
            for (DBInstance dbInstance : instancesResponse.dbInstances()) {
                if (supportedEngineIds.contains(dbInstance.engine())) {
                    instances.add(new AWSCloudRdsInstance(session, zone, dbInstance));
                    continue;
                }
                log.debug((Object)("Unsupported RDS engine: " + dbInstance.engine()));
            }
            return instances;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private AWSCloudRdsInstance findRdsInstance(@NotNull DBRProgressMonitor monitor, @NotNull AWSCloudSession session, @NotNull AWSCloudZone zone, String instanceId) throws DBException {
        monitor.subTask("Find RDS instance");
        Throwable throwable = null;
        Object var6_7 = null;
        try (RdsClient rdsClient = (RdsClient)this.configureClient(monitor, RdsClient.builder(), session, zone).build();){
            DescribeDbInstancesResponse instancesResponse = rdsClient.describeDBInstances((DescribeDbInstancesRequest)DescribeDbInstancesRequest.builder().dbInstanceIdentifier(instanceId).build());
            return instancesResponse.dbInstances().stream().findFirst().map(i -> new AWSCloudRdsInstance(session, zone, (DBInstance)i)).orElse(null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private List<AWSCloudDsqlCluster> findDsqlClusters(@NotNull DBRProgressMonitor monitor, @NotNull AWSCloudSession session, @NotNull AWSCloudZone zone) throws DBException {
        monitor.subTask("Describe DSQL clusters");
        Throwable throwable = null;
        Object var5_6 = null;
        try (DsqlClient dsqlClient = (DsqlClient)this.configureClient(monitor, DsqlClient.builder(), session, zone).build();){
            ListClustersResponse dsqlClustersResponse = dsqlClient.listClusters((ListClustersRequest)ListClustersRequest.builder().build());
            ArrayList<AWSCloudDsqlCluster> instances = new ArrayList<AWSCloudDsqlCluster>();
            for (ClusterSummary clusterSummary : dsqlClustersResponse.clusters()) {
                instances.add(new AWSCloudDsqlCluster(session, zone, clusterSummary));
            }
            return instances;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private AWSCloudDsqlCluster findDsqlCluster(@NotNull DBRProgressMonitor monitor, @NotNull AWSCloudSession session, @NotNull AWSCloudZone zone, String clusterId) throws DBException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (DsqlClient dsqlClient = (DsqlClient)this.configureClient(monitor, DsqlClient.builder(), session, zone).build();){
            monitor.subTask("Find DSQL cluster");
            GetClusterResponse clusterResponse = dsqlClient.getCluster((GetClusterRequest)GetClusterRequest.builder().identifier(clusterId).build());
            return new AWSCloudDsqlCluster(session, zone, (ClusterSummary)ClusterSummary.builder().identifier(clusterResponse.identifier()).arn(clusterResponse.arn()).build());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private List<AWSCloudAbstractInstance> findRedshiftInstances(@NotNull DBRProgressMonitor monitor, @NotNull AWSCloudSession session, @NotNull AWSCloudZone zone) throws DBException {
        monitor.subTask("Describe Redshift clusters");
        ArrayList<AWSCloudAbstractInstance> instances = new ArrayList<AWSCloudAbstractInstance>();
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (RedshiftClient redshiftClient = (RedshiftClient)this.configureClient(monitor, RedshiftClient.builder(), session, zone).build();){
            DescribeClustersResponse clusters = redshiftClient.describeClusters();
            for (Cluster dbInstance : clusters.clusters()) {
                instances.add(new AWSCloudRedshiftCluster(session, zone, dbInstance));
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        String account = this.callerIdentity.account();
        throwable2 = null;
        Object var7_10 = null;
        try (RedshiftServerlessClient client = (RedshiftServerlessClient)this.configureClient(monitor, RedshiftServerlessClient.builder(), session, zone).build();){
            ListWorkgroupsResponse workgroups = client.listWorkgroups((ListWorkgroupsRequest)ListWorkgroupsRequest.builder().ownerAccount(account).build());
            LinkedHashSet uniqueWorkgroups = new LinkedHashSet(workgroups.workgroups());
            for (Workgroup workgroup : uniqueWorkgroups) {
                instances.add(new AWSCloudRedshiftServerlessCluster(session, zone, account, workgroup));
            }
        }
        catch (Throwable throwable4) {
            if (throwable2 == null) {
                throwable2 = throwable4;
            } else if (throwable2 != throwable4) {
                throwable2.addSuppressed(throwable4);
            }
            throw throwable2;
        }
        return instances;
    }

    private AWSCloudAbstractInstance findRedshiftInstance(@NotNull DBRProgressMonitor monitor, @NotNull AWSCloudSession session, @NotNull AWSCloudZone zone, String clusterId) throws DBException {
        monitor.subTask("Find Redshift cluster");
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (RedshiftClient rdsClient = (RedshiftClient)this.configureClient(monitor, RedshiftClient.builder(), session, zone).build();){
                DescribeClustersResponse clusters = rdsClient.describeClusters((DescribeClustersRequest)DescribeClustersRequest.builder().clusterIdentifier(clusterId).build());
                return clusters.clusters().stream().findFirst().map(c -> new AWSCloudRedshiftCluster(session, zone, (Cluster)c)).orElse(null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ClusterNotFoundException clusterNotFoundException) {
            String account = this.callerIdentity.account();
            Throwable throwable = null;
            Object var7_13 = null;
            try (RedshiftServerlessClient rdsClient = (RedshiftServerlessClient)this.configureClient(monitor, RedshiftServerlessClient.builder(), session, zone).build();){
                GetWorkgroupResponse workgroup = rdsClient.getWorkgroup((GetWorkgroupRequest)GetWorkgroupRequest.builder().workgroupName(clusterId).build());
                return new AWSCloudRedshiftServerlessCluster(session, zone, account, workgroup.workgroup());
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
    }

    private List<AWSCloudDocumentDBCluster> findDocumentDBInstances(@NotNull DBRProgressMonitor monitor, @NotNull AWSCloudSession session, @NotNull AWSCloudZone zone) throws DBException {
        monitor.subTask("Describe DocumentDB clusters");
        Throwable throwable = null;
        Object var5_6 = null;
        try (DocDbClient docdbClient = (DocDbClient)this.configureClient(monitor, DocDbClient.builder(), session, zone).build();){
            DescribeDbClustersRequest clusterRequest = (DescribeDbClustersRequest)DescribeDbClustersRequest.builder().build();
            DescribeDbClustersResponse clustersResponse = docdbClient.describeDBClusters(clusterRequest);
            ArrayList<AWSCloudDocumentDBCluster> clusters = new ArrayList<AWSCloudDocumentDBCluster>();
            for (DBCluster dbInstance : clustersResponse.dbClusters()) {
                if (dbInstance.engine() != null && !dbInstance.engine().equals(AWSDatabaseEngine.DOCDB.getEngineId())) {
                    log.debug((Object)("Unsupported DocDB engine: " + dbInstance.engine()));
                    continue;
                }
                clusters.add(new AWSCloudDocumentDBCluster(session, zone, dbInstance));
            }
            return clusters;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private AWSCloudDocumentDBCluster findDocumentDBInstance(@NotNull DBRProgressMonitor monitor, @NotNull AWSCloudSession session, @NotNull AWSCloudZone zone, String clusterId) throws DBException {
        monitor.subTask("Find DocumentDB cluster");
        Throwable throwable = null;
        Object var6_7 = null;
        try (DocDbClient docdbClient = (DocDbClient)this.configureClient(monitor, DocDbClient.builder(), session, zone).build();){
            DescribeDbClustersResponse clustersResponse = docdbClient.describeDBClusters((DescribeDbClustersRequest)DescribeDbClustersRequest.builder().dbClusterIdentifier(clusterId).build());
            return clustersResponse.dbClusters().stream().findFirst().map(c -> new AWSCloudDocumentDBCluster(session, zone, (DBCluster)c)).orElse(null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private List<AWSCloudDynamoDBEndpoint> findDynamoDBInstances(@NotNull DBRProgressMonitor monitor, @NotNull AWSCloudSession session, @NotNull AWSCloudZone zone) throws DBException {
        monitor.subTask("Describe DynamoDB clusters");
        Throwable throwable = null;
        Object var5_6 = null;
        try (DynamoDbClient dynamoClient = (DynamoDbClient)this.configureClient(monitor, DynamoDbClient.builder(), session, zone).build();){
            DescribeEndpointsResponse endpoints = dynamoClient.describeEndpoints();
            ArrayList<AWSCloudDynamoDBEndpoint> dynamoEnpoints = new ArrayList<AWSCloudDynamoDBEndpoint>();
            for (Endpoint dbInstance : endpoints.endpoints()) {
                dynamoEnpoints.add(new AWSCloudDynamoDBEndpoint(session, zone, dbInstance, this.callerIdentity.account()));
            }
            return dynamoEnpoints;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private AWSCloudDynamoDBEndpoint findDynamoDBInstance(@NotNull DBRProgressMonitor monitor, @NotNull AWSCloudSession session, @NotNull AWSCloudZone zone) throws DBException {
        monitor.subTask("Find DynamoDB cluster");
        Throwable throwable = null;
        Object var5_6 = null;
        try (DynamoDbClient dynamoClient = (DynamoDbClient)this.configureClient(monitor, DynamoDbClient.builder(), session, zone).build();){
            DescribeEndpointsResponse endpoints = dynamoClient.describeEndpoints();
            return endpoints.endpoints().stream().findFirst().map(c -> new AWSCloudDynamoDBEndpoint(session, zone, (Endpoint)c, this.callerIdentity.account())).orElse(null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private List<AWSCloudTimestreamDatabase> findTimestreamDatabases(@NotNull DBRProgressMonitor monitor, @NotNull AWSCloudSession session, @NotNull AWSCloudZone zone) throws DBException {
        monitor.subTask("Describe Timestream databases");
        Throwable throwable = null;
        Object var5_6 = null;
        try (TimestreamWriteClient timestreamClient = (TimestreamWriteClient)this.configureClient(monitor, TimestreamWriteClient.builder(), session, zone).build();){
            ArrayList<AWSCloudTimestreamDatabase> timestreamEndpoints = new ArrayList<AWSCloudTimestreamDatabase>();
            ListDatabasesRequest ldr = (ListDatabasesRequest)ListDatabasesRequest.builder().build();
            ListDatabasesResponse listDatabasesResponse = timestreamClient.listDatabases(ldr);
            for (Database tsDatabase : listDatabasesResponse.databases()) {
                timestreamEndpoints.add(new AWSCloudTimestreamDatabase(session, zone, tsDatabase));
            }
            return timestreamEndpoints;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private AWSCloudTimestreamDatabase findTimestreamDatabase(@NotNull DBRProgressMonitor monitor, @NotNull AWSCloudSession session, @NotNull AWSCloudZone zone, String databaseName) throws DBException {
        return this.findTimestreamDatabases(monitor, session, zone).stream().filter(db -> db.getResourceId().equals(databaseName)).findFirst().orElse(null);
    }

    private List<AWSCloudNeptuneEndpoint> findNeptuneInstances(@NotNull DBRProgressMonitor monitor, @NotNull AWSCloudSession session, @NotNull AWSCloudZone zone) throws DBException {
        monitor.subTask("Describe Neptune clusters");
        Throwable throwable = null;
        Object var5_6 = null;
        try (NeptuneClient neptuneClient = (NeptuneClient)this.configureClient(monitor, NeptuneClient.builder(), session, zone).build();){
            ArrayList<AWSCloudNeptuneEndpoint> neptuneEndpoints = new ArrayList<AWSCloudNeptuneEndpoint>();
            software.amazon.awssdk.services.neptune.model.DescribeDbClustersResponse describeDbClustersResponse = neptuneClient.describeDBClusters();
            for (software.amazon.awssdk.services.neptune.model.DBCluster dbCluster : describeDbClustersResponse.dbClusters()) {
                if (!dbCluster.engine().equals("neptune")) continue;
                neptuneEndpoints.add(new AWSCloudNeptuneEndpoint(session, zone, dbCluster));
            }
            return neptuneEndpoints;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private AWSCloudNeptuneEndpoint findNeptuneInstance(@NotNull DBRProgressMonitor monitor, @NotNull AWSCloudSession session, @NotNull AWSCloudZone zone, String instanceId) throws DBException {
        monitor.subTask("Find Neptune cluster");
        Throwable throwable = null;
        Object var6_7 = null;
        try (NeptuneClient neptuneClient = (NeptuneClient)this.configureClient(monitor, NeptuneClient.builder(), session, zone).build();){
            software.amazon.awssdk.services.neptune.model.DescribeDbClustersRequest req = (software.amazon.awssdk.services.neptune.model.DescribeDbClustersRequest)software.amazon.awssdk.services.neptune.model.DescribeDbClustersRequest.builder().dbClusterIdentifier(instanceId).build();
            software.amazon.awssdk.services.neptune.model.DescribeDbClustersResponse dbClusters = neptuneClient.describeDBClusters(req);
            return dbClusters.dbClusters().stream().findFirst().map(c -> new AWSCloudNeptuneEndpoint(session, zone, (software.amazon.awssdk.services.neptune.model.DBCluster)c)).orElse(null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private List<AWSCloudAthenaEndpoint> findAthenaInstances(@NotNull DBRProgressMonitor monitor, @NotNull AWSCloudSession session, @NotNull AWSCloudZone zone) {
        return Collections.singletonList(this.findAthenaInstance(monitor, session, zone));
    }

    private AWSCloudAthenaEndpoint findAthenaInstance(@NotNull DBRProgressMonitor monitor, @NotNull AWSCloudSession session, @NotNull AWSCloudZone zone) {
        return new AWSCloudAthenaEndpoint(session, zone, this.callerIdentity.account());
    }

    private List<AWSCloudKeyspacesEndpoint> findKeyspacesInstances(@NotNull DBRProgressMonitor monitor, @NotNull AWSCloudSession session, @NotNull AWSCloudZone zone) {
        return Collections.singletonList(this.findKeyspacesInstance(monitor, session, zone));
    }

    private AWSCloudKeyspacesEndpoint findKeyspacesInstance(@NotNull DBRProgressMonitor monitor, @NotNull AWSCloudSession session, @NotNull AWSCloudZone zone) {
        return new AWSCloudKeyspacesEndpoint(session, zone);
    }

    @NotNull
    private List<AWSCloudElasticacheRedisCluster> findRedisInstances(@NotNull DBRProgressMonitor monitor, @NotNull AWSCloudSession session, @NotNull AWSCloudZone zone) throws DBException {
        monitor.subTask("Describe Redis clusters");
        Throwable throwable = null;
        Object var5_6 = null;
        try (ElastiCacheClient client = (ElastiCacheClient)this.configureClient(monitor, ElastiCacheClient.builder(), session, zone).build();){
            DescribeCacheClustersRequest req = (DescribeCacheClustersRequest)DescribeCacheClustersRequest.builder().showCacheNodeInfo(Boolean.valueOf(true)).build();
            DescribeCacheClustersResponse clusters = client.describeCacheClusters(req);
            ArrayList<AWSCloudElasticacheRedisCluster> instances = new ArrayList<AWSCloudElasticacheRedisCluster>();
            for (CacheCluster cacheCluster : clusters.cacheClusters()) {
                if (!cacheCluster.engine().equals("redis")) continue;
                instances.add(new AWSCloudElasticacheRedisCluster(session, zone, cacheCluster));
            }
            return instances;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Nullable
    private AWSCloudElasticacheRedisCluster findRedisInstance(@NotNull DBRProgressMonitor monitor, @NotNull AWSCloudSession session, @NotNull AWSCloudZone zone, @NotNull String clusterId) throws DBException {
        monitor.subTask("Find Redis cluster");
        Throwable throwable = null;
        Object var6_7 = null;
        try (ElastiCacheClient client = (ElastiCacheClient)this.configureClient(monitor, ElastiCacheClient.builder(), session, zone).build();){
            DescribeCacheClustersResponse clusters = client.describeCacheClusters(b -> {
                Object object = b.cacheClusterId(clusterId).showCacheNodeInfo(Boolean.valueOf(true)).build();
            });
            return clusters.cacheClusters().stream().findFirst().map(c -> new AWSCloudElasticacheRedisCluster(session, zone, (CacheCluster)c)).orElse(null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private <T extends AwsClientBuilder<?, ?>> T configureClient(@NotNull DBRProgressMonitor monitor, T builder, @NotNull AWSCloudSession session, @NotNull AWSCloudZone zone) throws DBException {
        Region region = zone.getRegion();
        builder.credentialsProvider(session.getIamCredentials().getAuthCredentialsProvider(monitor, null, region.id()));
        builder.region(region);
        return builder;
    }
}

