/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws;

import com.dbeaver.cloud.aws.AWSCloudService;
import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.AWSCloudZone;
import com.dbeaver.cloud.model.services.CPDatabaseFolder;
import com.dbeaver.cloud.model.services.CPDatabaseInstance;
import com.dbeaver.cloud.model.services.CPDatabaseNode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceConfigurationStorage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;

public abstract class AWSCloudAbstractInstance
implements CPDatabaseNode,
CPDatabaseInstance {
    private final AWSCloudSession session;
    private final AWSCloudZone zone;
    private static final Pattern INSTANCE_ARN_PATTERN = Pattern.compile("arn:(aws|aws-cn|aws-us-gov):([a-z0-9\\-]+):([a-z0-9\\-]+):([0-9]+)");
    private static final int INSTANCE_ARN_GROUP_SERVICE = 3;
    private static final int INSTANCE_ARN_GROUP_REGION = 3;
    private static final int INSTANCE_ARN_GROUP_ACCOUNT = 4;

    public AWSCloudAbstractInstance(AWSCloudSession session, AWSCloudZone zone) {
        this.session = session;
        this.zone = zone;
    }

    public AWSCloudSession getCloudSession() {
        return this.session;
    }

    @NotNull
    public String getCloudResourceId() {
        return this.getInstanceARN();
    }

    @Nullable
    public DBPImage getNodeIcon() {
        try {
            return this.getInstanceDriver().getIcon();
        }
        catch (DBException dBException) {
            return null;
        }
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @NotNull
    public AWSCloudZone getZone() {
        return this.zone;
    }

    @Nullable
    public CPDatabaseFolder getFolder() {
        return null;
    }

    @NotNull
    public String getNodeDisplayName() {
        return this.getNodeName();
    }

    @Property(viewable=true, order=0)
    @Nullable
    public String getAwsAccountId() {
        return this.getAccountIdFromConfiguration();
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getAwsRegionId() {
        return this.getZone().getZoneId();
    }

    @Property(viewable=true, order=2)
    @NotNull
    public String getAwsResourceARN() {
        return this.getInstanceARN();
    }

    @Property(viewable=true, order=3, href=true)
    @NotNull
    public String getAwsResourceLink() {
        return this.getExternalLink();
    }

    @NotNull
    public DBPDataSourceContainer createDataSourceContainer(@Nullable DBRProgressMonitor monitor, @NotNull DBPDataSourceRegistry dataSourceRegistry) throws DBException {
        String dsID = this.getCloudResourceId();
        DBPDriver driver = this.getInstanceDriver();
        DBPConnectionConfiguration configuration = new DBPConnectionConfiguration();
        this.setDataSourceConfiguration(configuration);
        DataSourceDescriptor dataSource = (DataSourceDescriptor)dataSourceRegistry.createDataSource((DBPDataSourceConfigurationStorage)this.session.getCloud().getDataSourceStorage(), this.session.getCloud().createOrigin(this.session.getCloud(), this.getZone(), this.getResourceId()), dsID, driver, configuration);
        dataSource.setHidden(true);
        String conName = driver.getName() + " - " + this.getNodeDisplayName();
        String awsAccountId = this.getAwsAccountId();
        if (awsAccountId != null) {
            conName = conName + " (" + awsAccountId + ")";
        }
        dataSource.setName(conName);
        dataSource.setSavePassword(!this.isDriverNeedsPassword(configuration));
        dataSourceRegistry.addDataSource((DBPDataSourceContainer)dataSource);
        return dataSource;
    }

    @NotNull
    protected String getResourceId() {
        return this.getInstanceARN();
    }

    protected boolean isDriverNeedsPassword(DBPConnectionConfiguration configuration) {
        return false;
    }

    protected abstract void setDataSourceConfiguration(DBPConnectionConfiguration var1) throws DBException;

    protected abstract AWSCloudService getCloudService();

    protected abstract String getInstanceARN();

    protected abstract String getExternalLink();

    @NotNull
    protected String getLinkPrefix() {
        return "https://" + this.getZone().getZoneId() + ".console.aws.amazon.com/" + this.getCloudService().getPrefix() + "/home?region=" + this.getZone().getZoneId() + "#";
    }

    @Nullable
    protected String getInstanceUserName() {
        return null;
    }

    @NotNull
    private DBPDriver getInstanceDriver() throws DBException {
        return this.getCloudService().getInstanceDriver();
    }

    @Nullable
    protected String getAccountIdFromConfiguration() {
        String instanceARN = this.getInstanceARN();
        if (instanceARN == null) {
            return null;
        }
        Matcher matcher = INSTANCE_ARN_PATTERN.matcher(instanceARN);
        if (matcher.find()) {
            return matcher.group(4);
        }
        return null;
    }
}

