/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws;

import com.dbeaver.cloud.aws.AWSCloudConfiguration;
import com.dbeaver.cloud.aws.AWSCloudDataSourceOrigin;
import com.dbeaver.cloud.aws.AWSCloudDataSourceStorage;
import com.dbeaver.cloud.aws.AWSCloudExplorer;
import com.dbeaver.cloud.aws.AWSCloudProvider;
import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.AWSCloudZone;
import com.dbeaver.cloud.impl.AbstractCloud;
import com.dbeaver.cloud.impl.AbstractCloudConfiguration;
import com.dbeaver.cloud.model.CPCloudProvider;
import com.dbeaver.cloud.model.CPCloudSessionManager;
import com.dbeaver.net.auth.aws.AWSIAMUtils;
import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import java.util.ArrayList;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.auth.SMSessionProviderService;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse;

public class AWSCloud
extends AbstractCloud<AWSCloudProvider, AWSCloudConfiguration, AWSCloudZone, AWSCloudSession>
implements CPCloudSessionManager<AWSCloudSession, AWSCloudZone> {
    private static final Log log = Log.getLog(AWSCloud.class);
    private final AWSCloudDataSourceStorage dataSourceStorage = new AWSCloudDataSourceStorage(this);

    AWSCloud(AWSCloudProvider provider, AWSCloudConfiguration configuration) {
        super((CPCloudProvider)provider, (AbstractCloudConfiguration)configuration);
    }

    @NotNull
    public AWSCloudZone[] getAllZones() {
        return (AWSCloudZone[])Region.regions().stream().filter(region -> !region.isGlobalRegion()).map(AWSCloudZone::valueOf).toArray(AWSCloudZone[]::new);
    }

    @NotNull
    public AWSCloudExplorer createExplorer(@NotNull DBRProgressMonitor monitor, @NotNull AWSCloudSession session) {
        return new AWSCloudExplorer(this, session);
    }

    public AWSCloudSession getActiveSession() {
        try {
            return (AWSCloudSession)DBWorkbench.getPlatform().getWorkspace().getAuthContext().getSpaceSession((DBRProgressMonitor)new VoidProgressMonitor(), (SMAuthSpace)this, false);
        }
        catch (Exception e) {
            log.debug((Object)e);
            return null;
        }
    }

    public String testConnection(DBRProgressMonitor monitor) throws DBException {
        SMSessionProviderService sessionProviderService = (SMSessionProviderService)DBWorkbench.getService(SMSessionProviderService.class);
        if (sessionProviderService == null) {
            throw new DBException("Can't obtain session provider");
        }
        monitor.beginTask("Connecting to AWS Cloud", 1);
        AWSCloudSession session = (AWSCloudSession)DBWorkbench.getPlatform().getWorkspace().getAuthContext().getSpaceSession(monitor, (SMAuthSpace)this, true);
        if (session == null) {
            throw new DBException("AWS session not found");
        }
        try {
            GetCallerIdentityResponse callerIdentity = this.readGetCallerIdentity(monitor, session);
            monitor.done();
            String string = callerIdentity.arn();
            return string;
        }
        finally {
            session.close();
        }
    }

    public String refreshSession(DBRProgressMonitor monitor) throws DBException {
        AWSCloudSession session = this.getActiveSession();
        if (session == null) {
            return "No active session, nothing to refresh";
        }
        if (session.getIamCredentials().refreshSession(monitor, null)) {
            return "SSO re-authenticated";
        }
        return "Nothing to refresh";
    }

    public void closeSession(DBRProgressMonitor monitor) throws DBException {
        AWSCloudSession session = this.getActiveSession();
        if (session != null) {
            session.getIamCredentials().closeSession(monitor);
        }
    }

    GetCallerIdentityResponse readGetCallerIdentity(DBRProgressMonitor monitor, AWSCloudSession session) throws DBException {
        monitor.subTask("Ping STS service");
        AuthModelAWSCredentials iamCredentials = session.getIamCredentials();
        Region region = ((AWSCloudConfiguration)this.getCloudConfiguration()).getStsRegion();
        Throwable throwable = null;
        Object var6_7 = null;
        try (StsClient stsClient = AWSIAMUtils.createStsClient((AwsCredentialsProvider)iamCredentials.getAuthCredentialsProvider(monitor, null, region.id()), (Region)region);){
            return (GetCallerIdentityResponse)AWSIAMUtils.tryExecuteRecover((DBRProgressMonitor)monitor, (AuthModelAWSCredentials)iamCredentials, () -> ((StsClient)stsClient).getCallerIdentity());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    AWSCloudDataSourceStorage getDataSourceStorage() {
        return this.dataSourceStorage;
    }

    @NotNull
    public AWSCloudZone[] getCloudAssignedZones() {
        ArrayList<AWSCloudZone> awsDefaultZones = new ArrayList<AWSCloudZone>();
        String[] stringArray = ((AWSCloudConfiguration)this.getCloudConfiguration()).getDefaultRegions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String regionId = stringArray[n2];
            awsDefaultZones.add(AWSCloudZone.valueOf(Region.of((String)regionId)));
            ++n2;
        }
        return awsDefaultZones.toArray(new AWSCloudZone[0]);
    }

    DBPDataSourceOrigin createOrigin(AWSCloud cloud, AWSCloudZone zone, String resourceId) {
        return AWSCloudDataSourceOrigin.createOrigin(this.getCloudId(), zone.getZoneId(), resourceId);
    }
}

