/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.custom.athena.jdbc.sdk2;

import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;

public class CustomIAMRoleAssumptionCredentialsProvider
implements AwsCredentialsProvider {
    private final String roleArn;
    private volatile AwsSessionCredentials assumedCredentials;
    private final StsClient stsClient;

    public CustomIAMRoleAssumptionCredentialsProvider(String accessKeyId, String secretAccessKey, String roleArn) {
        this(accessKeyId, secretAccessKey, roleArn, Region.AWS_GLOBAL);
    }

    public CustomIAMRoleAssumptionCredentialsProvider(String accessKeyId, String secretAccessKey, String roleArn, Region region) {
        this.roleArn = roleArn;
        this.stsClient = (StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().region(region)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsSessionCredentials.create((String)accessKeyId, (String)secretAccessKey, (String)"")))).build();
        this.refresh();
    }

    public AwsCredentials resolveCredentials() {
        if (this.assumedCredentials == null) {
            this.refresh();
        }
        return this.assumedCredentials;
    }

    public synchronized void refresh() {
        AssumeRoleRequest request = (AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(this.roleArn).roleSessionName("athenajdbc").build();
        AssumeRoleResponse response = this.stsClient.assumeRole(request);
        this.assumedCredentials = AwsSessionCredentials.create((String)response.credentials().accessKeyId(), (String)response.credentials().secretAccessKey(), (String)response.credentials().sessionToken());
    }

    public void close() {
        this.stsClient.close();
    }
}

