/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.bigquery.model.data;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCAbstractValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class BigQueryGeographyValueHandler
extends JDBCAbstractValueHandler {
    public static final BigQueryGeographyValueHandler INSTANCE = new BigQueryGeographyValueHandler();
    public static final String GEOGRAPHY_TYPE = "GEOGRAPHY";
    private static final Log log = Log.getLog(BigQueryGeographyValueHandler.class);

    @NotNull
    public Class<?> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return DBGeometry.class;
    }

    @Nullable
    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, @Nullable Object object, boolean copy, boolean validateValue) {
        if (object == null) {
            return new DBGeometry();
        }
        if (object instanceof String) {
            try {
                Geometry geometry = new WKTReader().read((String)object);
                return new DBGeometry((Object)geometry, 4326);
            }
            catch (ParseException e) {
                log.error((Object)"Error reading WKT from geography value", (Throwable)e);
            }
        }
        return object;
    }

    @Nullable
    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws SQLException {
        Object object = resultSet.getObject(index);
        return this.getValueFromObject(session, type, object, false, false);
    }

    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws SQLException {
        statement.setObject(paramIndex, value);
    }
}

