/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.nio;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.nio.AzurePath;
import com.azure.storage.blob.nio.LoggingUtility;
import com.azure.storage.blob.specialized.BlobInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;

public final class NioBlobInputStream
extends InputStream {
    private static final ClientLogger LOGGER = new ClientLogger(NioBlobInputStream.class);
    private final BlobInputStream blobInputStream;
    private final Path path;

    NioBlobInputStream(BlobInputStream blobInputStream, Path path) {
        this.blobInputStream = blobInputStream;
        this.path = path;
    }

    @Override
    public synchronized int available() throws IOException {
        AzurePath.ensureFileSystemOpen(this.path);
        return this.blobInputStream.available();
    }

    @Override
    public synchronized void close() throws IOException {
        AzurePath.ensureFileSystemOpen(this.path);
        this.blobInputStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.blobInputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.blobInputStream.markSupported();
    }

    @Override
    public int read() throws IOException {
        AzurePath.ensureFileSystemOpen(this.path);
        try {
            return this.blobInputStream.read();
        }
        catch (RuntimeException e) {
            throw LoggingUtility.logError(LOGGER, new IOException(e));
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        AzurePath.ensureFileSystemOpen(this.path);
        try {
            return this.blobInputStream.read(b);
        }
        catch (RuntimeException e) {
            throw LoggingUtility.logError(LOGGER, new IOException(e));
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        AzurePath.ensureFileSystemOpen(this.path);
        if (off < 0 || len < 0 || len > b.length - off) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IndexOutOfBoundsException());
        }
        try {
            return this.blobInputStream.read(b, off, len);
        }
        catch (RuntimeException e) {
            throw LoggingUtility.logError(LOGGER, new IOException(e));
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        AzurePath.ensureFileSystemOpen(this.path);
        try {
            this.blobInputStream.reset();
        }
        catch (RuntimeException e) {
            if (e.getMessage().equals("Stream mark expired.")) {
                throw LoggingUtility.logError(LOGGER, new IOException(e));
            }
            throw LoggingUtility.logError(LOGGER, e);
        }
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        AzurePath.ensureFileSystemOpen(this.path);
        return this.blobInputStream.skip(n);
    }

    BlobInputStream getBlobInputStream() {
        return this.blobInputStream;
    }
}

