/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.nio;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobContainerClientBuilder;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobListDetails;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.nio.AzurePath;
import com.azure.storage.blob.nio.DirectoryStatus;
import com.azure.storage.blob.nio.LoggingUtility;
import com.azure.storage.blob.options.BlockBlobOutputStreamOptions;
import com.azure.storage.blob.specialized.BlobOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class AzureResource {
    private static final ClientLogger LOGGER = new ClientLogger(AzureResource.class);
    static final String DIR_METADATA_MARKER = "hdi_isfolder";
    private final AzurePath path;
    private final BlobClient blobClient;
    private BlobHttpHeaders blobHeaders;
    private Map<String, String> blobMetadata;

    AzureResource(Path path) throws IOException {
        Objects.requireNonNull(path, "path");
        this.path = this.validatePathInstanceType(path);
        this.validateNotRoot();
        this.blobClient = this.path.toBlobClient();
    }

    boolean checkParentDirectoryExists() throws IOException {
        Path parent = this.path.getParent();
        return parent == null || parent.equals(this.path.getRoot()) || new AzureResource(this.path.getParent()).checkDirectoryExists();
    }

    boolean checkDirectoryExists() throws IOException {
        DirectoryStatus dirStatus = this.checkDirStatus();
        return dirStatus.equals((Object)DirectoryStatus.EMPTY) || dirStatus.equals((Object)DirectoryStatus.NOT_EMPTY);
    }

    boolean checkVirtualDirectoryExists() throws IOException {
        DirectoryStatus dirStatus = this.checkDirStatus(false);
        return dirStatus.equals((Object)DirectoryStatus.NOT_EMPTY);
    }

    DirectoryStatus checkDirStatus() throws IOException {
        boolean exists;
        BlobProperties props;
        block4: {
            if (this.blobClient == null) {
                throw LoggingUtility.logError(LOGGER, new IllegalArgumentException("The blob client was null."));
            }
            props = null;
            exists = false;
            try {
                props = this.getBlobClient().getProperties();
                exists = true;
            }
            catch (BlobStorageException e) {
                if (e.getStatusCode() == 404) break block4;
                throw LoggingUtility.logError(LOGGER, new IOException(e));
            }
        }
        if (exists && !props.getMetadata().containsKey(DIR_METADATA_MARKER)) {
            return DirectoryStatus.NOT_A_DIRECTORY;
        }
        return this.checkDirStatus(exists);
    }

    DirectoryStatus checkDirStatus(boolean exists) throws IOException {
        BlobContainerClient containerClient = this.getContainerClient();
        ListBlobsOptions listOptions = new ListBlobsOptions().setMaxResultsPerPage(Integer.valueOf(2)).setPrefix(this.blobClient.getBlobName() + "/").setDetails(new BlobListDetails().setRetrieveMetadata(true));
        try {
            Iterator blobIterator = containerClient.listBlobsByHierarchy("/", listOptions, null).iterator();
            if (blobIterator.hasNext()) {
                return DirectoryStatus.NOT_EMPTY;
            }
            if (exists) {
                return DirectoryStatus.EMPTY;
            }
            return DirectoryStatus.DOES_NOT_EXIST;
        }
        catch (BlobStorageException e) {
            throw LoggingUtility.logError(LOGGER, new IOException(e));
        }
    }

    void putDirectoryBlob(BlobRequestConditions requestConditions) {
        this.blobClient.getBlockBlobClient().commitBlockListWithResponse(Collections.emptyList(), this.blobHeaders, this.prepareMetadataForDirectory(), null, requestConditions, null, null);
    }

    private void extractHttpHeaders(List<FileAttribute<?>> fileAttributes) {
        BlobHttpHeaders headers = new BlobHttpHeaders();
        Iterator<FileAttribute<?>> it = fileAttributes.iterator();
        while (it.hasNext()) {
            FileAttribute<?> attr = it.next();
            boolean propertyFound = true;
            switch (attr.name()) {
                case "Content-Type": {
                    headers.setContentType(attr.value().toString());
                    break;
                }
                case "Content-Language": {
                    headers.setContentLanguage(attr.value().toString());
                    break;
                }
                case "Content-Disposition": {
                    headers.setContentDisposition(attr.value().toString());
                    break;
                }
                case "Content-Encoding": {
                    headers.setContentEncoding(attr.value().toString());
                    break;
                }
                case "Content-MD5": {
                    if (attr.value() instanceof byte[]) {
                        headers.setContentMd5((byte[])attr.value());
                        break;
                    }
                    throw LoggingUtility.logError(LOGGER, new UnsupportedOperationException("Content-MD5 attribute must be a byte[]"));
                }
                case "Cache-Control": {
                    headers.setCacheControl(attr.value().toString());
                    break;
                }
                default: {
                    propertyFound = false;
                }
            }
            if (!propertyFound) continue;
            it.remove();
        }
        this.blobHeaders = headers;
    }

    private void convertAttributesToMetadata(List<FileAttribute<?>> fileAttributes) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (FileAttribute<?> attr : fileAttributes) {
            metadata.put(attr.name(), attr.value().toString());
        }
        this.blobMetadata = metadata.isEmpty() ? null : metadata;
    }

    private void validateNotRoot() {
        if (this.path.isRoot()) {
            throw LoggingUtility.logError(LOGGER, new IllegalArgumentException("Root directory not supported. Path: " + this.path));
        }
    }

    private AzurePath validatePathInstanceType(Path path) {
        if (!(path instanceof AzurePath)) {
            throw LoggingUtility.logError(LOGGER, new IllegalArgumentException("This provider cannot operate on subtypes of Path other than AzurePath"));
        }
        return (AzurePath)path;
    }

    BlobContainerClient getContainerClient() {
        return new BlobContainerClientBuilder().endpoint(this.blobClient.getBlobUrl()).pipeline(this.blobClient.getHttpPipeline()).buildClient();
    }

    AzureResource setFileAttributes(List<FileAttribute<?>> attributes) {
        attributes = new ArrayList(attributes);
        this.extractHttpHeaders(attributes);
        this.convertAttributesToMetadata(attributes);
        return this;
    }

    AzurePath getPath() {
        return this.path;
    }

    BlobClient getBlobClient() {
        return this.blobClient;
    }

    BlobOutputStream getBlobOutputStream(ParallelTransferOptions pto, BlobRequestConditions rq) {
        BlockBlobOutputStreamOptions options = new BlockBlobOutputStreamOptions().setHeaders(this.blobHeaders).setMetadata(this.blobMetadata).setParallelTransferOptions(pto).setRequestConditions(rq);
        return this.blobClient.getBlockBlobClient().getBlobOutputStream(options);
    }

    private Map<String, String> prepareMetadataForDirectory() {
        if (this.blobMetadata == null) {
            this.blobMetadata = new HashMap<String, String>();
        }
        this.blobMetadata.put(DIR_METADATA_MARKER, "true");
        return this.blobMetadata;
    }
}

