/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.nio;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.nio.AzureFileSystem;
import com.azure.storage.blob.nio.LoggingUtility;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;
import java.util.Objects;

public final class AzureFileStore
extends FileStore {
    private static final ClientLogger LOGGER = new ClientLogger(AzureFileStore.class);
    private static final String AZURE_FILE_STORE_TYPE = "AzureBlobContainer";
    private final AzureFileSystem parentFileSystem;
    private final BlobContainerClient containerClient;

    AzureFileStore(AzureFileSystem parentFileSystem, String containerName, Boolean skipConnectionCheck) throws IOException {
        if (Objects.isNull(parentFileSystem)) {
            throw LoggingUtility.logError(LOGGER, new IllegalStateException("AzureFileStore cannot be instantiated without a parent FileSystem"));
        }
        this.parentFileSystem = parentFileSystem;
        this.containerClient = this.parentFileSystem.getBlobServiceClient().getBlobContainerClient(containerName);
        if (skipConnectionCheck == null || !skipConnectionCheck.booleanValue()) {
            try {
                if (!this.containerClient.exists()) {
                    this.containerClient.create();
                }
            }
            catch (Exception e) {
                throw LoggingUtility.logError(LOGGER, new IOException("There was an error in establishing the existence of container: " + containerName, e));
            }
        }
    }

    @Override
    public String name() {
        return this.containerClient.getBlobContainerName();
    }

    @Override
    public String type() {
        return AZURE_FILE_STORE_TYPE;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public long getTotalSpace() throws IOException {
        return Long.MAX_VALUE;
    }

    @Override
    public long getUsableSpace() throws IOException {
        return Long.MAX_VALUE;
    }

    @Override
    public long getUnallocatedSpace() throws IOException {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
        return AzureFileSystem.SUPPORTED_ATTRIBUTE_VIEWS.containsKey(type);
    }

    @Override
    public boolean supportsFileAttributeView(String name) {
        return AzureFileSystem.SUPPORTED_ATTRIBUTE_VIEWS.containsValue(name);
    }

    @Override
    public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> aClass) {
        return null;
    }

    @Override
    public Object getAttribute(String s) throws IOException {
        throw LoggingUtility.logError(LOGGER, new UnsupportedOperationException("FileStoreAttributeViews aren't supported."));
    }

    BlobContainerClient getContainerClient() {
        return this.containerClient;
    }
}

