/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.nio;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.nio.AzureBasicFileAttributes;
import com.azure.storage.blob.nio.AzurePath;
import com.azure.storage.blob.nio.LoggingUtility;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileTime;

public final class AzureBasicFileAttributeView
implements BasicFileAttributeView {
    private static final ClientLogger LOGGER = new ClientLogger(AzureBasicFileAttributeView.class);
    static final String NAME = "azureBasic";
    private final Path path;

    AzureBasicFileAttributeView(Path path) {
        this.path = path;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public AzureBasicFileAttributes readAttributes() throws IOException {
        AzurePath.ensureFileSystemOpen(this.path);
        return new AzureBasicFileAttributes(this.path);
    }

    @Override
    public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
        throw LoggingUtility.logError(LOGGER, new UnsupportedOperationException());
    }
}

