/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.gcp;

import com.dbeaver.cloud.gcp.GCPCloud;
import com.dbeaver.cloud.gcp.GCPCloudAbstractInstance;
import com.dbeaver.cloud.gcp.GCPCloudExplorer;
import com.dbeaver.cloud.gcp.GCPCloudService;
import com.dbeaver.cloud.gcp.GCPCloudSession;
import com.dbeaver.cloud.gcp.GCPCloudZone;
import com.dbeaver.cloud.gcp.GCPProject;
import com.dbeaver.cloud.model.services.CPDatabaseFolder;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.cloud.registry.DataSourceOriginCloud;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPExternalConfiguration;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.access.DBACredentialsProvider;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class GCPCloudDataSourceOrigin
extends DataSourceOriginCloud<GCPCloud, GCPCloudZone>
implements DBACredentialsProvider {
    private static final Log log = Log.getLog(GCPCloudDataSourceOrigin.class);
    static final String PROPERTY_PROJECT_ID = "gcp-project";
    static final String PROPERTY_RESOURCE_ID = "gcp-resource";
    static final String PROPERTY_NODE_ID = "gcp-node-id";

    public GCPCloudDataSourceOrigin(CloudProviderDescriptor cloudProvider, Map<String, Object> configuration, DBPExternalConfiguration externalConfiguration) {
        super(cloudProvider, configuration, externalConfiguration);
    }

    public String getProjectId() {
        return CommonUtils.toString(this.getDataSourceConfiguration().get(PROPERTY_PROJECT_ID));
    }

    public String getNodeID() {
        return CommonUtils.toString(this.getDataSourceConfiguration().get(PROPERTY_NODE_ID));
    }

    public String getResourceId() {
        return CommonUtils.toString(this.getDataSourceConfiguration().get(PROPERTY_RESOURCE_ID));
    }

    @Nullable
    public DBPObject getObjectDetails(@NotNull DBRProgressMonitor monitor, @NotNull SMSessionContext sessionContext, @NotNull DBPDataSourceContainer dataSource) throws DBException {
        GCPCloudService service = GCPCloudService.getServiceByDriver(dataSource.getDriver());
        if (service == null) {
            log.error((Object)("Cannot detect GCP service for driver " + dataSource.getDriver().getFullName()));
            return null;
        }
        GCPCloudAbstractInstance instance = this.getDatabaseInstance(monitor, sessionContext, service);
        if (instance == null) {
            log.error((Object)(service.getServiceId() + " instance '" + this.getResourceId() + "' not found"));
        }
        return instance;
    }

    public GCPCloudAbstractInstance getDatabaseInstance(DBRProgressMonitor monitor, SMSessionContext sessionContext, GCPCloudService service) throws DBException {
        GCPCloud cloud = (GCPCloud)this.getCloud();
        SMSession cloudSession = sessionContext.getSpaceSession(monitor, (SMAuthSpace)cloud, true);
        if (cloudSession instanceof GCPCloudSession) {
            GCPCloudExplorer cloudExplorer = cloud.createExplorer(monitor, (GCPCloudSession)cloudSession);
            return cloudExplorer.getDatabaseInstance(monitor, service.getServiceId(), (CPDatabaseFolder)new GCPProject(this.getProjectId()), (GCPCloudZone)this.getZone(), this.getNodeID());
        }
        throw new DBException("GCP cloud session not found");
    }

    public boolean provideAuthParameters(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSourceContainer, @NotNull DBPConnectionConfiguration configuration) throws DBException {
        SMSession cloudSession = dataSourceContainer.getProject().getSessionContext().getSpaceSession(monitor, (SMAuthSpace)this.getCloud(), true);
        if (cloudSession instanceof GCPCloudSession) {
            return ((GCPCloudSession)cloudSession).provideAuthParameters(monitor, dataSourceContainer, configuration);
        }
        return false;
    }

    @NotNull
    public String getAuthContextType() {
        return "gcp";
    }
}

