/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.create.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;

public class CreateSchema
implements Statement {
    private String authorization;
    private String schemaName;
    private List<String> schemaPath;
    private List<Statement> statements = new ArrayList<Statement>();

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public boolean addStatement(Statement statement) {
        return this.statements.add(statement);
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public List<String> getSchemaPath() {
        return this.schemaPath;
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public void setAuthorization(String authorization) {
        this.authorization = authorization;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setSchemaPath(List<String> schemaPath) {
        this.schemaPath = schemaPath;
    }

    public String toString() {
        String sql = "CREATE SCHEMA";
        if (this.schemaName != null) {
            sql = sql + " " + this.schemaName;
        }
        if (this.authorization != null) {
            sql = sql + " AUTHORIZATION " + this.authorization;
        }
        return sql;
    }

    public CreateSchema withAuthorization(String authorization) {
        this.setAuthorization(authorization);
        return this;
    }

    public CreateSchema withSchemaName(String schemaName) {
        this.setSchemaName(schemaName);
        return this;
    }

    public CreateSchema withSchemaPath(List<String> schemaPath) {
        this.setSchemaPath(schemaPath);
        return this;
    }

    public CreateSchema addSchemaPath(String ... schemaPath) {
        List collection = Optional.ofNullable(this.getSchemaPath()).orElseGet(ArrayList::new);
        Collections.addAll(collection, schemaPath);
        return this.withSchemaPath(collection);
    }

    public CreateSchema addSchemaPath(Collection<String> schemaPath) {
        List collection = Optional.ofNullable(this.getSchemaPath()).orElseGet(ArrayList::new);
        collection.addAll(schemaPath);
        return this.withSchemaPath(collection);
    }
}

