/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.config;

import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import com.datical.liquibase.ext.util.ProStringUtil;
import liquibase.configuration.AutoloadedConfigurations;
import liquibase.configuration.ConfigurationDefinition;

public class LiquibaseSnowflakeConfiguration
implements AutoloadedConfigurations {
    public static final ConfigurationDefinition<String> AUTHENTICATION_TYPE;
    public static final ConfigurationDefinition<String> PRIVATE_KEY_FILE_PATH;
    public static final ConfigurationDefinition<String> PRIVATE_KEY_FILE_PASSPHRASE;
    public static final ConfigurationDefinition<String> AUTHENTICATION_TOKEN;

    static {
        ConfigurationDefinition.Builder builder = new ConfigurationDefinition.Builder("liquibase.snowflake");
        AUTHENTICATION_TYPE = builder.define("auth.type", String.class).setDescription(ProStringUtil.markWithPro("The type or mechanism of Snowflake database authentication")).setValueHandler(value -> {
            if (value == null) {
                return null;
            }
            LiquibaseProConfiguration.checkLicense("auth-type");
            return value.toString();
        }).build();
        PRIVATE_KEY_FILE_PATH = builder.define("auth.privateKeyPath", String.class).setDescription(ProStringUtil.markWithPro("Path to private key used for PKI Authentication type. Usually requires 'snowflake-auth-type' property configured.")).setValueHandler(value -> {
            if (value == null) {
                return null;
            }
            LiquibaseProConfiguration.checkLicense("auth-private-key-path");
            return value.toString();
        }).build();
        PRIVATE_KEY_FILE_PASSPHRASE = builder.define("auth.privateKeyPassphrase", String.class).setDescription(ProStringUtil.markWithPro("Path to private key used for PKI Authentication type. Usually requires 'snowflake-auth-type' property configured.")).setValueHandler(value -> {
            if (value == null) {
                return null;
            }
            LiquibaseProConfiguration.checkLicense("auth-private-key-passphrase");
            return value.toString();
        }).build();
        AUTHENTICATION_TOKEN = builder.define("auth.token", String.class).setDescription(ProStringUtil.markWithPro("Value of the token used for specified Authentication type. Usually requires 'snowflake-auth-type' property configured.")).setValueHandler(value -> {
            if (value == null) {
                return null;
            }
            LiquibaseProConfiguration.checkLicense("auth-token");
            return value.toString();
        }).build();
    }
}

