/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.UpdateOneChangeSetCommandStep;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.helpers.DatabaseChangelogCommandStep;
import liquibase.database.Database;
import liquibase.exception.CommandValidationException;
import liquibase.license.LicenseServiceUtils;
import liquibase.util.LoggingExecutorTextUtil;

public class UpdateOneChangeSetSqlCommandStep
extends UpdateOneChangeSetCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"updateOneChangesetSql"};
    public static final CommandArgumentDefinition<String> CHANGESET_ID;
    public static final CommandArgumentDefinition<String> CHANGESET_AUTHOR;
    public static final CommandArgumentDefinition<String> CHANGESET_PATH;

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Generates sql to run single changeset"));
    }

    public List<Class<?>> requiredDependencies() {
        ArrayList dependencies = new ArrayList();
        dependencies.add(Writer.class);
        dependencies.add(Database.class);
        dependencies.addAll(super.requiredDependencies());
        return dependencies;
    }

    @Override
    public void validate(CommandScope commandScope) throws CommandValidationException {
        this.checkArgs(commandScope, false);
    }

    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])COMMAND_NAME);
        CommandScope commandScope = resultsBuilder.getCommandScope();
        Database database = (Database)commandScope.getDependency(Database.class);
        String changelogFile = (String)commandScope.getArgumentValue(DatabaseChangelogCommandStep.CHANGELOG_FILE_ARG);
        String changeSetId = (String)commandScope.getArgumentValue(CHANGESET_ID_ARG);
        String changeSetAuthor = (String)commandScope.getArgumentValue(CHANGESET_AUTHOR_ARG);
        String changeSetPath = (String)commandScope.getArgumentValue(CHANGESET_PATH_ARG);
        LoggingExecutorTextUtil.outputHeader((String)("Update " + changeSetId + "::" + changeSetAuthor + "::" + changeSetPath + " Changeset Database Script"), (Database)database, (String)changelogFile);
        super.run(resultsBuilder);
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHANGESET_ID = commandBuilder.argument("changesetId", String.class).description("Id of the changeset to execute").required().build();
        CHANGESET_AUTHOR = commandBuilder.argument("changesetAuthor", String.class).description("Author of the changeset to execute").required().build();
        CHANGESET_PATH = commandBuilder.argument("changesetPath", String.class).description("Path to the changeset to execute").required().build();
    }
}

