/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changeset;

import com.datical.liquibase.ext.changeset.ProChangeSet;
import com.datical.liquibase.ext.changeset.ProModifyChangeSets;
import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.ModifyChangeSets;
import liquibase.changeset.StandardChangeSetService;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.license.LicenseServiceUtils;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.ParsedNodeException;

public class ProChangeSetService
extends StandardChangeSetService {
    private boolean endDelimiterWarningIssued;
    private boolean stripCommentsWarningIssued;

    public int getPriority() {
        if (LicenseServiceUtils.isProLicenseValid()) {
            return 101;
        }
        return -1;
    }

    public ChangeSet createChangeSet(DatabaseChangeLog changeLog) {
        return new ProChangeSet(changeLog);
    }

    public ChangeSet createChangeSet(String id, String author, boolean alwaysRun, boolean runOnChange, String filePath, String contextFilter, String dbmsList, DatabaseChangeLog databaseChangeLog) {
        return this.createChangeSet(id, author, alwaysRun, runOnChange, filePath, contextFilter, dbmsList, null, null, true, ObjectQuotingStrategy.LEGACY, databaseChangeLog);
    }

    public ChangeSet createChangeSet(String id, String author, boolean alwaysRun, boolean runOnChange, String filePath, String contextFilter, String dbmsList, String runWith, String runWithSpoolFile, boolean runInTransaction, ObjectQuotingStrategy quotingStrategy, DatabaseChangeLog databaseChangeLog) {
        return new ProChangeSet(id, author, alwaysRun, runOnChange, DatabaseChangeLog.normalizePath((String)filePath), contextFilter, dbmsList, runWith, runWithSpoolFile, runInTransaction, quotingStrategy, databaseChangeLog);
    }

    public ModifyChangeSets createModifyChangeSets(ParsedNode node) throws ParsedNodeException {
        return new ProModifyChangeSets(node);
    }

    public ModifyChangeSets createModifyChangeSets(String runWith, String runWithSpool, boolean stripComments) {
        return new ProModifyChangeSets(runWith, runWithSpool, stripComments);
    }

    public void modifyChangeSets(ChangeSet changeSet, ModifyChangeSets modifyChangeSets) {
        if (changeSet == null) {
            return;
        }
        super.modifyChangeSets(changeSet, modifyChangeSets);
        changeSet.getChanges().stream().filter(AbstractSQLChange.class::isInstance).forEach(change -> this.setAttributeForChange((ProModifyChangeSets)modifyChangeSets, (AbstractSQLChange)change));
        changeSet.getRollback().getChanges().stream().filter(AbstractSQLChange.class::isInstance).forEach(change -> this.setAttributeForChange((ProModifyChangeSets)modifyChangeSets, (AbstractSQLChange)change));
    }

    private void setAttributeForChange(ProModifyChangeSets modifyChangeSets, AbstractSQLChange change) {
        this.setEndDelimiterForChange(modifyChangeSets, change);
        this.setStripCommentsForChange(change);
    }

    private void setEndDelimiterForChange(ProModifyChangeSets modifyChangeSets, AbstractSQLChange change) {
        String endDelimiter = this.handleGlobalEndDelimiter(change.getEndDelimiter());
        if (endDelimiter == null) {
            endDelimiter = ProChangeSetService.determineEndDelimiter(modifyChangeSets, change);
        }
        change.setEndDelimiter(endDelimiter);
    }

    private void setStripCommentsForChange(AbstractSQLChange change) {
        Boolean stripComments = this.handleGlobalStripComments(change.isStripComments());
        if (stripComments == null) {
            stripComments = ProChangeSetService.determineStripComments(change);
        }
        change.setStripComments(stripComments);
    }

    public String getEndDelimiter(ChangeSet changeSet) {
        if (changeSet == null) {
            return (String)LiquibaseProConfiguration.GLOBAL_END_DELIMITER.getCurrentValue();
        }
        return ((ProChangeSet)changeSet).getEndDelimiter();
    }

    public String getOverrideDelimiter(String endDelimiter) {
        return this.handleGlobalEndDelimiter(endDelimiter);
    }

    public Boolean getOverrideStripComments(boolean stripComments) {
        return this.handleGlobalStripComments(stripComments);
    }

    public Boolean getStripComments(ChangeSet changeSet) {
        if (changeSet == null) {
            return (Boolean)LiquibaseProConfiguration.GLOBAL_STRIP_COMMENTS.getCurrentValue();
        }
        return ((ProChangeSet)changeSet).isStripComments();
    }

    private String handleGlobalEndDelimiter(String endDelimiter) {
        if (Boolean.TRUE.equals(LiquibaseProConfiguration.GLOBAL_END_DELIMITER_PRIORITIZED.getCurrentValue())) {
            String globalEndDelimiter = (String)LiquibaseProConfiguration.GLOBAL_END_DELIMITER.getCurrentValue();
            if (globalEndDelimiter == null && !this.endDelimiterWarningIssued) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("The '--pro-global-end-delimiter-prioritization' property is set to use the global end delimiter to override local end delimiter setting, but no global end delimiter is set. No prioritization action occurred.");
                this.endDelimiterWarningIssued = true;
            }
            if (globalEndDelimiter != null) {
                endDelimiter = globalEndDelimiter;
            }
        }
        return endDelimiter;
    }

    private Boolean handleGlobalStripComments(Boolean stripComments) {
        if (Boolean.TRUE.equals(LiquibaseProConfiguration.GLOBAL_STRIP_COMMENTS_PRIORITIZED.getCurrentValue())) {
            Boolean globalStripComments = (Boolean)LiquibaseProConfiguration.GLOBAL_STRIP_COMMENTS.getCurrentValue();
            if (globalStripComments == null && !this.stripCommentsWarningIssued) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("The '--strip-comments-prioritized' property is set to use the global end delimiter to override local end delimiter setting, but no global end delimiter is set. No prioritization action occurred.");
                this.stripCommentsWarningIssued = true;
            }
            if (globalStripComments != null) {
                stripComments = globalStripComments;
            }
        }
        return stripComments;
    }

    private static String determineEndDelimiter(ProModifyChangeSets modifyChangeSets, AbstractSQLChange change) {
        String endDelimiter = change.getEndDelimiter();
        if (endDelimiter == null) {
            endDelimiter = modifyChangeSets.getEndDelimiter();
        }
        return endDelimiter;
    }

    private static Boolean determineStripComments(AbstractSQLChange change) {
        return change.isStripComments();
    }
}

