/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security.oauth;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.security.Credentials;
import io.confluent.ksql.security.KsqlClientConfig;
import io.confluent.ksql.security.oauth.CachedOAuthTokenRetriever;
import io.confluent.ksql.security.oauth.OAuthTokenCache;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenValidator;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigurationUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.HttpAccessTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JaasOptionsUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.LoginAccessTokenValidator;

public class OAuthBearerCredentials
implements Credentials {
    private CachedOAuthTokenRetriever tokenRetriever;

    public void configure(Map<String, ?> configs) {
        this.validateConfigs(configs);
        ConfigurationUtils configUtils = new ConfigurationUtils(configs);
        CachedOAuthTokenRetriever cachedOAuthTokenRetriever = new CachedOAuthTokenRetriever(this.getAccessTokenRetriever(configUtils, configs), this.getAccessTokenValidator(configs), this.getOAuthTokenCache(configs));
        this.init(cachedOAuthTokenRetriever);
    }

    @VisibleForTesting
    void init(CachedOAuthTokenRetriever tokenRetriever) {
        this.tokenRetriever = tokenRetriever;
    }

    @Override
    public String getAuthHeader() {
        return "Bearer " + this.retrieveToken();
    }

    @Override
    public void validateConfigs(Map<String, ?> configs) throws ConfigException {
        String tokenEndpointUrl = (String)configs.get("bearer.auth.issuer.endpoint.url");
        String clientId = (String)configs.get("bearer.auth.client.id");
        String clientSecret = (String)configs.get("bearer.auth.client.secret");
        if (tokenEndpointUrl == null || tokenEndpointUrl.isEmpty()) {
            throw new ConfigException("Cannot configure OAuthBearerCredentials without proper tokenEndpointUrl.");
        }
        if (clientId == null || clientId.isEmpty()) {
            throw new ConfigException("Cannot configure OAuthBearerCredentials without proper clientId.");
        }
        if (clientSecret == null || clientSecret.isEmpty()) {
            throw new ConfigException("Cannot configure OAuthBearerCredentials without proper clientSecret.");
        }
    }

    public String retrieveToken() {
        return this.tokenRetriever.getToken();
    }

    private AccessTokenRetriever getAccessTokenRetriever(ConfigurationUtils configUtils, Map<String, ?> configs) {
        String clientId = configUtils.validateString("bearer.auth.client.id");
        String clientSecret = configUtils.validateString("bearer.auth.client.secret");
        String scope = configUtils.validateString("bearer.auth.scope", false);
        long retryBackoffMs = 100L;
        long retryBackoffMaxMs = 10000L;
        Integer loginConnectTimeoutMs = null;
        Integer loginReadTimeoutMs = null;
        JaasOptionsUtils jaasOptionsUtils = new JaasOptionsUtils(KsqlClientConfig.getClientSslConfig(configs));
        SSLSocketFactory socketFactory = null;
        URL tokenEndpointUrl = configUtils.validateUrl("bearer.auth.issuer.endpoint.url");
        if (jaasOptionsUtils.shouldCreateSSLSocketFactory(tokenEndpointUrl)) {
            socketFactory = jaasOptionsUtils.createSSLSocketFactory();
        }
        return new HttpAccessTokenRetriever(clientId, clientSecret, scope, socketFactory, tokenEndpointUrl.toString(), 100L, 10000L, loginConnectTimeoutMs, loginReadTimeoutMs, false);
    }

    private AccessTokenValidator getAccessTokenValidator(Map<String, ?> configs) {
        String scopeClaimName = KsqlClientConfig.getBearerAuthScopeClaimName(configs);
        String subClaimName = KsqlClientConfig.getBearerAuthSubClaimName(configs);
        return new LoginAccessTokenValidator(scopeClaimName, subClaimName);
    }

    private OAuthTokenCache getOAuthTokenCache(Map<String, ?> configs) {
        short cacheExpiryBufferSeconds = KsqlClientConfig.getBearerAuthCacheExpiryBufferSeconds(configs);
        return new OAuthTokenCache(cacheExpiryBufferSeconds);
    }
}

