/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security.oauth;

import java.util.Objects;

public final class IdpConfig {
    private String idpTokenEndpointUrl = "";
    private String idpClientId = "";
    private String idpClientSecret = "";
    private String idpScope = "";
    private String idpScopeClaimName = "scope";
    private String idpSubClaimName = "sub";
    private Short idpCacheExpiryBufferSeconds = 300;

    private IdpConfig() {
    }

    public String getIdpTokenEndpointUrl() {
        return this.idpTokenEndpointUrl;
    }

    public String getIdpClientId() {
        return this.idpClientId;
    }

    public String getIdpClientSecret() {
        return this.idpClientSecret;
    }

    public String getIdpScope() {
        return this.idpScope;
    }

    public String getIdpScopeClaimName() {
        return this.idpScopeClaimName;
    }

    public String getIdpSubClaimName() {
        return this.idpSubClaimName;
    }

    public Short getIdpCacheExpiryBufferSeconds() {
        return this.idpCacheExpiryBufferSeconds;
    }

    public IdpConfig copy() {
        return new Builder().withTokenEndpointUrl(this.idpTokenEndpointUrl).withClientId(this.idpClientId).withClientSecret(this.idpClientSecret).withScope(this.idpScope).withScopeClaimName(this.idpScopeClaimName).withSubClaimName(this.idpSubClaimName).withCacheExpiryBufferSeconds(this.idpCacheExpiryBufferSeconds).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdpConfig)) {
            return false;
        }
        IdpConfig idpConfig = (IdpConfig)o;
        return Objects.equals(this.idpTokenEndpointUrl, idpConfig.idpTokenEndpointUrl) && Objects.equals(this.idpClientId, idpConfig.idpClientId) && Objects.equals(this.idpClientSecret, idpConfig.idpClientSecret) && Objects.equals(this.idpScope, idpConfig.idpScope) && Objects.equals(this.idpScopeClaimName, idpConfig.idpScopeClaimName) && Objects.equals(this.idpSubClaimName, idpConfig.idpSubClaimName) && Objects.equals(this.idpCacheExpiryBufferSeconds, idpConfig.idpCacheExpiryBufferSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.idpTokenEndpointUrl, this.idpClientId, this.idpClientSecret, this.idpScope, this.idpScopeClaimName, this.idpSubClaimName, this.idpCacheExpiryBufferSeconds);
    }

    public String toString() {
        return "IdpConfig{idpTokenEndpointUrl='" + this.idpTokenEndpointUrl + '\'' + ", idpClientId='" + this.idpClientId + '\'' + ", idpClientSecret='" + this.idpClientSecret + '\'' + ", idpScope='" + this.idpScope + '\'' + ", idpScopeClaimName='" + this.idpScopeClaimName + '\'' + ", idpSubClaimName='" + this.idpSubClaimName + '\'' + ", idpCacheExpiryBufferSeconds=" + this.idpCacheExpiryBufferSeconds + '}';
    }

    public static class Builder {
        private final IdpConfig config = new IdpConfig();

        public Builder withTokenEndpointUrl(String url) {
            this.config.idpTokenEndpointUrl = url;
            return this;
        }

        public Builder withClientId(String clientId) {
            this.config.idpClientId = clientId;
            return this;
        }

        public Builder withClientSecret(String clientSecret) {
            this.config.idpClientSecret = clientSecret;
            return this;
        }

        public Builder withScope(String scope) {
            this.config.idpScope = scope;
            return this;
        }

        public Builder withScopeClaimName(String scopeClaimName) {
            this.config.idpScopeClaimName = scopeClaimName;
            return this;
        }

        public Builder withSubClaimName(String subClaimName) {
            this.config.idpSubClaimName = subClaimName;
            return this;
        }

        public Builder withCacheExpiryBufferSeconds(Short cacheExpiryBufferSeconds) {
            this.config.idpCacheExpiryBufferSeconds = cacheExpiryBufferSeconds;
            return this;
        }

        public IdpConfig build() {
            return this.config;
        }
    }
}

