/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.PersistenceSchema;
import io.confluent.ksql.serde.SerdeFeatures;
import java.util.Objects;

@Immutable
public final class PhysicalSchema {
    private final LogicalSchema logicalSchema;
    private final PersistenceSchema keySchema;
    private final PersistenceSchema valueSchema;

    public static PhysicalSchema from(LogicalSchema logicalSchema, SerdeFeatures keyFeatures, SerdeFeatures valueFeatures) {
        return new PhysicalSchema(logicalSchema, keyFeatures, valueFeatures);
    }

    public LogicalSchema logicalSchema() {
        return this.logicalSchema;
    }

    public PersistenceSchema keySchema() {
        return this.keySchema;
    }

    public PersistenceSchema valueSchema() {
        return this.valueSchema;
    }

    private PhysicalSchema(LogicalSchema logicalSchema, SerdeFeatures keyFeatures, SerdeFeatures valueFeatures) {
        this.logicalSchema = Objects.requireNonNull(logicalSchema, "logicalSchema");
        this.keySchema = PersistenceSchema.from(logicalSchema.key(), keyFeatures);
        this.valueSchema = PersistenceSchema.from(logicalSchema.value(), valueFeatures);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhysicalSchema that = (PhysicalSchema)o;
        return Objects.equals(this.keySchema, that.keySchema) && Objects.equals(this.valueSchema, that.valueSchema);
    }

    public int hashCode() {
        return Objects.hash(this.keySchema, this.valueSchema);
    }

    public String toString() {
        return "PhysicalSchema{keySchema=" + this.keySchema + ", valueSchema=" + this.valueSchema + '}';
    }
}

