/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.firestore.model;

import com.dbeaver.db.google.firestore.data.FireStoreDocument;
import com.dbeaver.db.google.firestore.exec.FireStoreExecutionContext;
import com.dbeaver.db.google.firestore.exec.FireStoreSession;
import com.dbeaver.db.google.firestore.model.FireStoreCollection;
import com.dbeaver.db.google.firestore.model.FireStoreDataSourceInfo;
import com.dbeaver.db.google.firestore.model.FireStoreDialect;
import com.dbeaver.db.google.firestore.model.FirestoreDataType;
import com.dbeaver.model.NoSQLDataSource;
import com.dbeaver.model.NoSQLDialect;
import com.dbeaver.model.document.DocumentDataManager;
import com.dbeaver.model.document.data.DBCHierarchicalDocumentProvider;
import com.dbeaver.model.document.data.DBMapValue;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FirestoreException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformProvider;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.impl.sql.QueryTransformerLimit;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.BasicObjectCache;

public class FireStoreDatasource
extends NoSQLDataSource<FireStoreExecutionContext>
implements DocumentDataManager<FireStoreDatasource, Map<String, Object>>,
DBPRefreshableObject,
DBPDataTypeProvider,
IAdaptable,
DBCQueryTransformProvider,
DBCHierarchicalDocumentProvider<FireStoreCollection> {
    private static final Gson JSON_BUILDER = new GsonBuilder().setPrettyPrinting().setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").registerTypeAdapter(Timestamp.class, (Object)new FireStoreDocument.TimestampJsonConverter()).registerTypeAdapter(Date.class, (Object)new FireStoreDocument.DateJsonConverter()).serializeNulls().create();
    private final CollectionCache collectionCache = new CollectionCache();
    private final Map<String, FireStoreCollection> subCollectionsGlobalCache = new HashMap<String, FireStoreCollection>();
    private List<FirestoreDataType> dataTypes;

    public FireStoreDatasource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        super(container);
        this.executionContext = new FireStoreExecutionContext(this, "Main Firestore Connection");
        ((FireStoreExecutionContext)this.executionContext).connect(monitor);
    }

    @NotNull
    public DBPDataSourceInfo getInfo() {
        return new FireStoreDataSourceInfo(this);
    }

    @NotNull
    public NoSQLDialect getSQLDialect() {
        return new FireStoreDialect();
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
    }

    public List<FireStoreCollection> listChildrenEntities(String documentPath, @NotNull DBRProgressMonitor monitor, boolean refresh) throws DBCException {
        ArrayList<FireStoreCollection> collections = new ArrayList<FireStoreCollection>();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FireStoreSession session = (FireStoreSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Read SubCollection");){
                DocumentReference document = session.getExecutionContext().getService().document(documentPath);
                for (CollectionReference collectionReference : document.listCollections()) {
                    collections.add(this.getChildrenEntityInstance(collectionReference.getPath(), monitor, refresh, false));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FirestoreException e) {
            throw new DBCException("Error reading sub-collections at '" + documentPath + "'", (Throwable)e);
        }
        return collections;
    }

    public FireStoreCollection getChildrenEntityInstance(String path, @NotNull DBRProgressMonitor monitor, boolean refresh, boolean checkExists) throws DBCException {
        if (this.subCollectionsGlobalCache.get(path) == null || refresh) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (FireStoreSession session = (FireStoreSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Read SubCollection");){
                    CollectionReference collection = session.getExecutionContext().getService().collection(path);
                    if (checkExists) {
                        DocumentReference parent = collection.getParent();
                        AtomicBoolean collectionExists = new AtomicBoolean(false);
                        if (parent != null) {
                            parent.listCollections().forEach(it -> {
                                if (it.getPath().equals(path)) {
                                    collectionExists.set(true);
                                }
                            });
                        } else {
                            session.getExecutionContext().getService().listCollections().forEach(it -> {
                                if (it.getPath().equals(path)) {
                                    collectionExists.set(true);
                                }
                            });
                        }
                        if (!collectionExists.get()) {
                            throw new DBCException("Sub Collection not Found " + path);
                        }
                    }
                    FireStoreCollection fireStoreCollection = new FireStoreCollection(this, collection.getId(), collection.getPath(), true);
                    this.subCollectionsGlobalCache.put(path, fireStoreCollection);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FirestoreException e) {
                throw new DBCException("Error reading sub documents at '" + path + "'", (Throwable)e);
            }
        }
        return this.subCollectionsGlobalCache.get(path);
    }

    public void removeChildrenEntity(String path) {
        this.subCollectionsGlobalCache.remove(path);
    }

    public void serializeDocument(Map<String, Object> document, Writer writer) {
        JSON_BUILDER.toJson(document, (Appendable)writer);
    }

    public Map<String, Object> deserializeDocument(Reader reader) {
        return JSONUtils.parseMap((Gson)JSON_BUILDER, (Reader)reader);
    }

    public DBMapValue<FireStoreDatasource> convertNativeDocumentToMap(Map<String, Object> value) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public Map<String, Object> convertMapToNativeDocument(DBMapValue<FireStoreDatasource> map) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public DBSDataType getDocumentDataType(int typeId) {
        return this.getLocalDataType(typeId);
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int typeID) {
        return DBPDataKind.OBJECT;
    }

    @Nullable
    public DBSDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull String typeFullName) {
        return null;
    }

    @NotNull
    public Collection<? extends DBSDataType> getLocalDataTypes() {
        return this.dataTypes;
    }

    @Nullable
    public FirestoreDataType getLocalDataType(String typeName) {
        for (FirestoreDataType type : this.dataTypes) {
            if (!type.getTypeName().equals(typeName)) continue;
            return type;
        }
        return null;
    }

    @Nullable
    public FirestoreDataType getLocalDataType(int typeID) {
        for (FirestoreDataType type : this.dataTypes) {
            if (type.getTypeID() != typeID) continue;
            return type;
        }
        return null;
    }

    @NotNull
    public String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        return null;
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.collectionCache.clearCache();
        this.subCollectionsGlobalCache.clear();
        this.initialize(monitor);
        return this;
    }

    @NotNull
    public FireStoreExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor monitor, @NotNull String purpose, @Nullable DBCExecutionContext initFrom) throws DBException {
        FireStoreExecutionContext context = new FireStoreExecutionContext(this, purpose);
        context.connect(monitor);
        return context;
    }

    @Nullable
    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.collectionCache.getAllObjects(monitor, this);
    }

    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        if (type == DBCQueryTransformType.RESULT_SET_LIMIT) {
            return new QueryTransformerLimit(false, true);
        }
        return null;
    }

    @Nullable
    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.collectionCache.getObject(monitor, (DBSObject)this, childName);
    }

    public CollectionCache getCollectionCache() {
        return this.collectionCache;
    }

    @Association
    public Collection<FireStoreCollection> getCollections(DBRProgressMonitor monitor) throws DBException {
        return this.collectionCache.getAllObjects(monitor, this);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return FireStoreCollection.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    public Object getDataSourceFeature(String featureId) {
        if ("datasource.document-data-source".equals(featureId)) {
            return Boolean.TRUE;
        }
        return null;
    }

    class CollectionCache
    extends BasicObjectCache<FireStoreDatasource, FireStoreCollection> {
        CollectionCache() {
        }

        @NotNull
        public List<FireStoreCollection> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable FireStoreDatasource dataSource) throws DBException {
            if (!this.isFullyCached() && !monitor.isForceCacheUsage()) {
                ArrayList<FireStoreCollection> databaseList = new ArrayList<FireStoreCollection>();
                Throwable throwable = null;
                Object var5_6 = null;
                try (FireStoreSession session = (FireStoreSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)FireStoreDatasource.this, (String)"Read Collections");){
                    for (CollectionReference collection : session.getExecutionContext().getService().listCollections()) {
                        databaseList.add(new FireStoreCollection(dataSource, collection.getId(), collection.getPath(), true));
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                this.setCache(databaseList);
            }
            return this.getCachedObjects();
        }
    }
}

