/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.firestore.exec;

import com.dbeaver.db.google.firestore.data.FireStoreDocument;
import com.dbeaver.db.google.firestore.exec.FireStoreBaseStatement;
import com.dbeaver.db.google.firestore.exec.FireStoreSession;
import com.dbeaver.db.google.firestore.model.FireStoreCollection;
import java.util.Arrays;
import java.util.HashMap;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.data.DBDDocument;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;

public class FireStoreRemoveStatement
extends FireStoreBaseStatement {
    private final FireStoreCollection collection;
    private final DBSAttributeBase[] keyAttributes;
    private Object[] rowValues;

    public FireStoreRemoveStatement(FireStoreSession session, FireStoreCollection mongoCollection, DBSAttributeBase[] keyAttributes, Object[] rowValues) {
        super(session, null);
        this.collection = mongoCollection;
        this.keyAttributes = keyAttributes;
        this.rowValues = rowValues;
    }

    @Override
    @Nullable
    public String getQueryString() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean executeStatement() throws DBCException {
        try {
            String id;
            if (this.keyAttributes.length == 1 && this.keyAttributes[0].getDataKind() == DBPDataKind.DOCUMENT) {
                id = (String)((FireStoreDocument)((Object)this.rowValues[0])).getDocumentId();
            } else {
                if (this.keyAttributes.length == 0) throw new DBCException("Unsupported document value: " + Arrays.toString(this.keyAttributes));
                HashMap<String, Object> o = new HashMap<String, Object>();
                int i = 0;
                while (i < this.keyAttributes.length) {
                    o.put(this.keyAttributes[i].getName(), this.rowValues[i]);
                    ++i;
                }
                DBDDocument dbdDocument = this.collection.findDocument(this.getSession(), o, null);
                if (dbdDocument == null) throw new DBCException("Document id is not found");
                id = (String)dbdDocument.getDocumentId();
            }
            ((FireStoreSession)this.getSession()).getExecutionContext().getService().document(this.collection.getPath() + "/" + id).delete();
            return false;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
    }

    public DBSEntity getSourceEntity() {
        return this.collection;
    }

    public void setRowValues(Object[] attributeValues) {
        this.rowValues = attributeValues;
    }
}

