/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.firestore.exec;

import com.dbeaver.db.google.firestore.FirestoreUtils;
import com.dbeaver.db.google.firestore.data.FireStoreDocument;
import com.dbeaver.db.google.firestore.exec.FireStoreBaseStatement;
import com.dbeaver.db.google.firestore.exec.FireStoreSession;
import com.dbeaver.db.google.firestore.model.FireStoreCollection;
import com.dbeaver.db.google.firestore.model.FireStoreDatasource;
import com.dbeaver.model.document.data.DBMapValue;
import com.google.api.core.ApiFuture;
import com.google.cloud.firestore.DocumentReference;
import java.io.StringReader;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;

public class FireStoreInsertStatement
extends FireStoreBaseStatement {
    private final FireStoreCollection collection;
    private final DBSAttributeBase[] valueAttributes;
    private Object[] rowValues;

    public FireStoreInsertStatement(FireStoreSession session, FireStoreCollection database, DBSAttributeBase[] updateAttributes, Object[] rowValues) {
        super(session, null);
        this.collection = database;
        this.valueAttributes = updateAttributes;
        this.rowValues = rowValues;
    }

    public void setRowValues(Object[] rowValues) {
        this.rowValues = rowValues;
    }

    public boolean executeStatement() throws DBCException {
        try {
            if (this.valueAttributes.length == 1 && this.valueAttributes[0].getDataKind() == DBPDataKind.DOCUMENT) {
                Object[] objectArray = this.rowValues;
                int n = this.rowValues.length;
                int n2 = 0;
                while (n2 < n) {
                    Map<String, Object> docMap;
                    Object rowValue;
                    block21: {
                        rowValue = objectArray[n2];
                        if (rowValue instanceof FireStoreDocument) {
                            FireStoreDocument document = (FireStoreDocument)((Object)rowValue);
                            DBMapValue rootNode = document.getRootNode();
                            docMap = rootNode.getRawValue();
                        } else {
                            if (rowValue instanceof String) {
                                String json = (String)rowValue;
                                try {
                                    Throwable throwable = null;
                                    Object var9_13 = null;
                                    try (StringReader reader = new StringReader(json);){
                                        docMap = ((FireStoreDatasource)((FireStoreSession)this.getSession()).getDataSource()).deserializeDocument(reader);
                                        break block21;
                                    }
                                    catch (Throwable throwable2) {
                                        if (throwable == null) {
                                            throwable = throwable2;
                                        } else if (throwable != throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        throw throwable;
                                    }
                                }
                                catch (Exception exception) {
                                    throw new DBCException("Failure deserializing : %s".formatted(rowValue));
                                }
                            }
                            throw new DBCException("Unsupported row value: %s".formatted(Arrays.toString(this.valueAttributes)));
                        }
                    }
                    docMap = FirestoreUtils.cleanupDocumentMapProperties(docMap);
                    ApiFuture document = ((FireStoreSession)this.getSession()).getExecutionContext().getService().collection(this.collection.getPath()).add(docMap);
                    if (rowValue instanceof FireStoreDocument) {
                        FireStoreDocument fireStoreDocument = (FireStoreDocument)((Object)rowValue);
                        DocumentReference documentReference = (DocumentReference)document.get(20L, TimeUnit.SECONDS);
                        fireStoreDocument.setId(documentReference.getId());
                        fireStoreDocument.setPath(documentReference.getPath());
                    }
                    ++n2;
                }
            } else {
                Map<String, Object> docMap = new LinkedHashMap<String, Object>();
                int i = 0;
                while (i < this.valueAttributes.length) {
                    docMap.put(this.valueAttributes[i].getName(), this.rowValues[i]);
                    ++i;
                }
                docMap = FirestoreUtils.cleanupDocumentMapProperties(docMap);
                ((FireStoreSession)this.getSession()).getExecutionContext().getService().collection(this.collection.getPath()).add(docMap);
            }
            return false;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
    }

    public DBSEntity getSourceEntity() {
        return this.collection;
    }
}

