/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.engine.aws;

import com.google.gson.annotations.SerializedName;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.engine.AIEngineProperties;
import org.jkiss.dbeaver.model.ai.utils.AIUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.SecureProperty;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import software.amazon.awssdk.regions.Region;

public class AwsBedrockProperties
implements AIEngineProperties {
    private static final String AWS_ACCESS = "aws.access_key";
    private static final String AWS_SECRET_ACCESS = "aws.secret_access";
    private static final String AWS_REGION = "aws.region";
    private static final String AWS_LOG_QUERY = "aws.log.query";
    private static final String AWS_MODEL = "aws.model";
    private static final String AWS_TEMPERATURE = "aws.temperature";
    private static final String AWS_CONTEXT_WINDOW_SIZE = "aws.contextWindowSize";
    private static final String AWS_SHOW_INFERENCES = "aws.showInferences";
    @SerializedName(value="aws.region")
    private String awsRegion;
    @SerializedName(value="aws.model")
    private String model;
    @SecureProperty
    @SerializedName(value="aws.access_key")
    private String accessKeyId;
    @SecureProperty
    @SerializedName(value="aws.secret_access")
    private String secretAccessKey;
    @SerializedName(value="aws.log.query")
    private boolean loggingEnabled;
    @SerializedName(value="aws.contextWindowSize")
    private Integer contextWindowSize;
    @SerializedName(value="aws.temperature")
    private double temperature;
    @SerializedName(value="aws.showInferences")
    private boolean showInferences;

    public boolean isValidConfiguration() {
        return this.accessKeyId != null && !this.accessKeyId.isEmpty() && this.secretAccessKey != null && !this.secretAccessKey.isEmpty() && this.awsRegion != null && this.contextWindowSize != 0 && this.model != null && !this.model.isEmpty();
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void resolveSecrets() throws DBException {
        this.accessKeyId = AIUtils.getSecretValueOrDefault((String)AWS_ACCESS, (String)this.accessKeyId);
        this.secretAccessKey = AIUtils.getSecretValueOrDefault((String)AWS_SECRET_ACCESS, (String)this.secretAccessKey);
    }

    public void saveSecrets() throws DBException {
        if (this.accessKeyId != null && !this.accessKeyId.isEmpty()) {
            DBSSecretController.getGlobalSecretController().setPrivateSecretValue(AWS_ACCESS, this.accessKeyId);
        }
        if (this.secretAccessKey != null && !this.secretAccessKey.isEmpty()) {
            DBSSecretController.getGlobalSecretController().setPrivateSecretValue(AWS_SECRET_ACCESS, this.secretAccessKey);
        }
    }

    @Property(order=1, password=true, required=true)
    public String getAccessKey() {
        return this.accessKeyId;
    }

    @Property(order=2, password=true, required=true)
    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }

    @Property(order=3, required=true)
    public String getAwsRegionId() {
        return this.awsRegion;
    }

    @Property(order=4)
    public String getModel() {
        return this.model;
    }

    public boolean isShowInferences() {
        return this.showInferences;
    }

    @Property(order=5)
    public Integer getContextWindowSize() {
        return this.contextWindowSize;
    }

    @Property(order=6)
    public double getTemperature() {
        return this.temperature;
    }

    public Region getAwsRegion() {
        return Region.of((String)this.awsRegion);
    }

    public void setModel(@NotNull String model) {
        this.model = model;
    }

    public void setAwsRegionId(@NotNull String awsRegion) {
        this.awsRegion = awsRegion;
    }

    public void setAccessKey(@NotNull String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public void setSecretAccessKey(@NotNull String secretAccessKey) {
        this.secretAccessKey = secretAccessKey;
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    public void setShowInferences(boolean showInferences) {
        this.showInferences = showInferences;
    }

    public void setContextWindowSize(@NotNull Integer contextWindowSize) {
        this.contextWindowSize = contextWindowSize;
    }
}

