/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.kafka.model;

import com.dbeaver.db.kafka.KSQLUtils;
import com.dbeaver.db.kafka.model.KSQLDataSource;
import io.confluent.ksql.api.client.FieldInfo;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;

public class KSQLField
implements DBSEntityAttribute {
    private final KSQLDataSource dataSource;
    private final FieldInfo field;
    private final DBSEntity parent;

    public KSQLField(@NotNull FieldInfo field, @Nullable KSQLDataSource dataSource, @NotNull DBSEntity parent) {
        this.field = field;
        this.dataSource = dataSource;
        this.parent = parent;
    }

    @Property(order=0, viewable=true)
    @NotNull
    public String getName() {
        return this.field.name();
    }

    @Property(order=1, viewable=true)
    public String getType() {
        return this.field.type().getType().name();
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }

    @NotNull
    public DBSEntity getParentObject() {
        return this.parent;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    public int getOrdinalPosition() {
        return 0;
    }

    public boolean isRequired() {
        return false;
    }

    public boolean isAutoGenerated() {
        return false;
    }

    @Nullable
    public String getDefaultValue() {
        return null;
    }

    @NotNull
    public String getTypeName() {
        return null;
    }

    @NotNull
    public String getFullTypeName() {
        return null;
    }

    public int getTypeID() {
        return 0;
    }

    @NotNull
    public DBPDataKind getDataKind() {
        return KSQLUtils.convertKSQLColumnType(this.field.type().getType());
    }

    @Nullable
    public Integer getScale() {
        return null;
    }

    public Integer getPrecision() {
        return null;
    }

    public long getMaxLength() {
        return 0L;
    }

    public long getTypeModifiers() {
        return 0L;
    }
}

