/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.grpclb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import io.grpc.Attributes;
import io.grpc.Channel;
import io.grpc.ChannelLogger;
import io.grpc.ClientStreamTracer;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.grpclb.BackendAddressGroup;
import io.grpc.grpclb.GrpclbClientLoadRecorder;
import io.grpc.grpclb.GrpclbConstants;
import io.grpc.grpclb.LbAddressGroup;
import io.grpc.grpclb.SubchannelPool;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.GrpcAttributes;
import io.grpc.internal.TimeProvider;
import io.grpc.lb.v1.ClientStats;
import io.grpc.lb.v1.InitialLoadBalanceRequest;
import io.grpc.lb.v1.InitialLoadBalanceResponse;
import io.grpc.lb.v1.LoadBalanceRequest;
import io.grpc.lb.v1.LoadBalanceResponse;
import io.grpc.lb.v1.LoadBalancerGrpc;
import io.grpc.lb.v1.Server;
import io.grpc.lb.v1.ServerList;
import io.grpc.stub.StreamObserver;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class GrpclbState {
    static final long FALLBACK_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(10L);
    private static final Attributes LB_PROVIDED_BACKEND_ATTRS = Attributes.newBuilder().set(GrpcAttributes.ATTR_LB_PROVIDED_BACKEND, (Object)true).build();
    @VisibleForTesting
    static final LoadBalancer.PickResult DROP_PICK_RESULT = LoadBalancer.PickResult.withDrop((Status)Status.UNAVAILABLE.withDescription("Dropped as requested by balancer"));
    @VisibleForTesting
    static final RoundRobinEntry BUFFER_ENTRY = new RoundRobinEntry(){

        @Override
        public LoadBalancer.PickResult picked(Metadata headers) {
            return LoadBalancer.PickResult.withNoResult();
        }

        public String toString() {
            return "BUFFER_ENTRY";
        }
    };
    private final String serviceName;
    private final LoadBalancer.Helper helper;
    private final SynchronizationContext syncContext;
    private final SubchannelPool subchannelPool;
    private final TimeProvider time;
    private final ScheduledExecutorService timerService;
    private static final Attributes.Key<AtomicReference<ConnectivityStateInfo>> STATE_INFO = Attributes.Key.create((String)"io.grpc.grpclb.GrpclbLoadBalancer.stateInfo");
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final ChannelLogger logger;
    @Nullable
    private SynchronizationContext.ScheduledHandle fallbackTimer;
    private List<EquivalentAddressGroup> fallbackBackendList = Collections.emptyList();
    private boolean usingFallbackBackends;
    private boolean balancerWorking;
    @Nullable
    private BackoffPolicy lbRpcRetryPolicy;
    @Nullable
    private SynchronizationContext.ScheduledHandle lbRpcRetryTimer;
    private long prevLbRpcStartNanos;
    @Nullable
    private ManagedChannel lbCommChannel;
    @Nullable
    private LbStream lbStream;
    private Map<EquivalentAddressGroup, LoadBalancer.Subchannel> subchannels = Collections.emptyMap();
    private List<DropEntry> dropList = Collections.emptyList();
    private List<BackendEntry> backendList = Collections.emptyList();
    private RoundRobinPicker currentPicker = new RoundRobinPicker(Collections.emptyList(), Arrays.asList(BUFFER_ENTRY));

    GrpclbState(LoadBalancer.Helper helper, SubchannelPool subchannelPool, TimeProvider time, BackoffPolicy.Provider backoffPolicyProvider) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)helper.getSynchronizationContext(), (Object)"syncContext");
        this.subchannelPool = (SubchannelPool)Preconditions.checkNotNull((Object)subchannelPool, (Object)"subchannelPool");
        this.time = (TimeProvider)Preconditions.checkNotNull((Object)time, (Object)"time provider");
        this.timerService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)helper.getScheduledExecutorService(), (Object)"timerService");
        this.backoffPolicyProvider = (BackoffPolicy.Provider)Preconditions.checkNotNull((Object)backoffPolicyProvider, (Object)"backoffPolicyProvider");
        this.serviceName = (String)Preconditions.checkNotNull((Object)helper.getAuthority(), (Object)"helper returns null authority");
        this.logger = (ChannelLogger)Preconditions.checkNotNull((Object)helper.getChannelLogger(), (Object)"logger");
    }

    void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo newState) {
        if (newState.getState() == ConnectivityState.SHUTDOWN || !this.subchannels.values().contains(subchannel)) {
            return;
        }
        if (newState.getState() == ConnectivityState.IDLE) {
            subchannel.requestConnection();
        }
        ((AtomicReference)subchannel.getAttributes().get(STATE_INFO)).set(newState);
        this.maybeUseFallbackBackends();
        this.maybeUpdatePicker();
    }

    void handleAddresses(List<LbAddressGroup> newLbAddressGroups, List<EquivalentAddressGroup> newBackendServers) {
        if (newLbAddressGroups.isEmpty()) {
            this.propagateError(Status.UNAVAILABLE.withDescription("NameResolver returned no LB address while asking for GRPCLB"));
            return;
        }
        LbAddressGroup newLbAddressGroup = this.flattenLbAddressGroups(newLbAddressGroups);
        this.startLbComm(newLbAddressGroup);
        if (this.lbStream == null) {
            this.startLbRpc();
        }
        this.fallbackBackendList = newBackendServers;
        if (this.fallbackTimer == null) {
            this.fallbackTimer = this.syncContext.schedule((Runnable)new FallbackModeTask(), FALLBACK_TIMEOUT_MS, TimeUnit.MILLISECONDS, this.timerService);
        }
        if (this.usingFallbackBackends) {
            this.useFallbackBackends();
        }
        this.maybeUpdatePicker();
    }

    private void maybeUseFallbackBackends() {
        if (this.balancerWorking) {
            return;
        }
        if (this.usingFallbackBackends) {
            return;
        }
        for (LoadBalancer.Subchannel subchannel : this.subchannels.values()) {
            if (((ConnectivityStateInfo)((AtomicReference)subchannel.getAttributes().get(STATE_INFO)).get()).getState() != ConnectivityState.READY) continue;
            return;
        }
        this.useFallbackBackends();
    }

    private void useFallbackBackends() {
        this.usingFallbackBackends = true;
        this.logger.log(ChannelLogger.ChannelLogLevel.INFO, "Using fallback backends");
        ArrayList<DropEntry> newDropList = new ArrayList<DropEntry>();
        ArrayList<BackendAddressGroup> newBackendAddrList = new ArrayList<BackendAddressGroup>();
        for (EquivalentAddressGroup eag : this.fallbackBackendList) {
            newDropList.add(null);
            newBackendAddrList.add(new BackendAddressGroup(eag, null));
        }
        this.useRoundRobinLists(newDropList, newBackendAddrList, null);
    }

    private void shutdownLbComm() {
        if (this.lbCommChannel != null) {
            this.lbCommChannel.shutdown();
            this.lbCommChannel = null;
        }
        this.shutdownLbRpc();
    }

    private void shutdownLbRpc() {
        if (this.lbStream != null) {
            this.lbStream.close(null);
        }
    }

    private void startLbComm(LbAddressGroup lbAddressGroup) {
        Preconditions.checkNotNull((Object)lbAddressGroup, (Object)"lbAddressGroup");
        if (this.lbCommChannel == null) {
            this.lbCommChannel = this.helper.createOobChannel(lbAddressGroup.getAddresses(), lbAddressGroup.getAuthority());
        } else if (lbAddressGroup.getAuthority().equals(this.lbCommChannel.authority())) {
            this.helper.updateOobChannelAddresses(this.lbCommChannel, lbAddressGroup.getAddresses());
        } else {
            this.shutdownLbComm();
            this.lbCommChannel = this.helper.createOobChannel(lbAddressGroup.getAddresses(), lbAddressGroup.getAuthority());
        }
    }

    private void startLbRpc() {
        Preconditions.checkState((this.lbStream == null ? 1 : 0) != 0, (Object)"previous lbStream has not been cleared yet");
        LoadBalancerGrpc.LoadBalancerStub stub = LoadBalancerGrpc.newStub((Channel)this.lbCommChannel);
        this.lbStream = new LbStream(stub);
        this.lbStream.start();
        this.prevLbRpcStartNanos = this.time.currentTimeNanos();
        LoadBalanceRequest initRequest = LoadBalanceRequest.newBuilder().setInitialRequest(InitialLoadBalanceRequest.newBuilder().setName(this.serviceName).build()).build();
        try {
            this.lbStream.lbRequestWriter.onNext((Object)initRequest);
        }
        catch (Exception e) {
            this.lbStream.close(e);
        }
    }

    private void cancelFallbackTimer() {
        if (this.fallbackTimer != null) {
            this.fallbackTimer.cancel();
        }
    }

    private void cancelLbRpcRetryTimer() {
        if (this.lbRpcRetryTimer != null) {
            this.lbRpcRetryTimer.cancel();
        }
    }

    void shutdown() {
        this.shutdownLbComm();
        for (LoadBalancer.Subchannel subchannel : this.subchannels.values()) {
            this.subchannelPool.returnSubchannel(subchannel);
        }
        this.subchannels = Collections.emptyMap();
        this.subchannelPool.clear();
        this.cancelFallbackTimer();
        this.cancelLbRpcRetryTimer();
    }

    void propagateError(Status status) {
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Error: {0}", new Object[]{status});
        if (this.backendList.isEmpty()) {
            this.maybeUpdatePicker(ConnectivityState.TRANSIENT_FAILURE, new RoundRobinPicker(this.dropList, Arrays.asList(new ErrorEntry(status))));
        }
    }

    @Nullable
    @VisibleForTesting
    GrpclbClientLoadRecorder getLoadRecorder() {
        if (this.lbStream == null) {
            return null;
        }
        return this.lbStream.loadRecorder;
    }

    private void useRoundRobinLists(List<DropEntry> newDropList, List<BackendAddressGroup> newBackendAddrList, @Nullable GrpclbClientLoadRecorder loadRecorder) {
        EquivalentAddressGroup eag;
        this.logger.log(ChannelLogger.ChannelLogLevel.INFO, "Using RR list={0}, drop={1}", new Object[]{newBackendAddrList, newDropList});
        HashMap<EquivalentAddressGroup, LoadBalancer.Subchannel> newSubchannelMap = new HashMap<EquivalentAddressGroup, LoadBalancer.Subchannel>();
        ArrayList<BackendEntry> newBackendList = new ArrayList<BackendEntry>();
        for (BackendAddressGroup backendAddressGroup : newBackendAddrList) {
            eag = backendAddressGroup.getAddresses();
            LoadBalancer.Subchannel subchannel = (LoadBalancer.Subchannel)newSubchannelMap.get(eag);
            if (subchannel == null) {
                subchannel = this.subchannels.get(eag);
                if (subchannel == null) {
                    Attributes subchannelAttrs = Attributes.newBuilder().set(STATE_INFO, new AtomicReference<ConnectivityStateInfo>(ConnectivityStateInfo.forNonError((ConnectivityState)ConnectivityState.IDLE))).build();
                    subchannel = this.subchannelPool.takeOrCreateSubchannel(eag, subchannelAttrs);
                    subchannel.requestConnection();
                }
                newSubchannelMap.put(eag, subchannel);
            }
            BackendEntry entry = backendAddressGroup.getToken() == null ? new BackendEntry(subchannel) : new BackendEntry(subchannel, loadRecorder, backendAddressGroup.getToken());
            newBackendList.add(entry);
        }
        for (Map.Entry entry : this.subchannels.entrySet()) {
            eag = (EquivalentAddressGroup)entry.getKey();
            if (newSubchannelMap.containsKey(eag)) continue;
            this.subchannelPool.returnSubchannel((LoadBalancer.Subchannel)entry.getValue());
        }
        this.subchannels = Collections.unmodifiableMap(newSubchannelMap);
        this.dropList = Collections.unmodifiableList(newDropList);
        this.backendList = Collections.unmodifiableList(newBackendList);
    }

    private void maybeUpdatePicker() {
        ConnectivityState state;
        ArrayList<RoundRobinEntry> pickList = new ArrayList<RoundRobinEntry>(this.backendList.size());
        Status error = null;
        boolean hasIdle = false;
        for (BackendEntry entry : this.backendList) {
            LoadBalancer.Subchannel subchannel = entry.result.getSubchannel();
            Attributes attrs = subchannel.getAttributes();
            ConnectivityStateInfo stateInfo = (ConnectivityStateInfo)((AtomicReference)attrs.get(STATE_INFO)).get();
            if (stateInfo.getState() == ConnectivityState.READY) {
                pickList.add(entry);
                continue;
            }
            if (stateInfo.getState() == ConnectivityState.TRANSIENT_FAILURE) {
                error = stateInfo.getStatus();
                continue;
            }
            if (stateInfo.getState() != ConnectivityState.IDLE) continue;
            hasIdle = true;
        }
        if (pickList.isEmpty()) {
            if (error != null && !hasIdle) {
                pickList.add(new ErrorEntry(error));
                state = ConnectivityState.TRANSIENT_FAILURE;
            } else {
                pickList.add(BUFFER_ENTRY);
                state = ConnectivityState.CONNECTING;
            }
        } else {
            state = ConnectivityState.READY;
        }
        this.maybeUpdatePicker(state, new RoundRobinPicker(this.dropList, pickList));
    }

    private void maybeUpdatePicker(ConnectivityState state, RoundRobinPicker picker) {
        if (picker.dropList.equals(this.currentPicker.dropList) && picker.pickList.equals(this.currentPicker.pickList)) {
            return;
        }
        this.currentPicker = picker;
        this.logger.log(ChannelLogger.ChannelLogLevel.INFO, "{0}: picks={1}, drops={2}", new Object[]{state, picker.pickList, picker.dropList});
        this.helper.updateBalancingState(state, (LoadBalancer.SubchannelPicker)picker);
    }

    private LbAddressGroup flattenLbAddressGroups(List<LbAddressGroup> groupList) {
        assert (!groupList.isEmpty());
        ArrayList<EquivalentAddressGroup> eags = new ArrayList<EquivalentAddressGroup>(groupList.size());
        String authority = groupList.get(0).getAuthority();
        for (LbAddressGroup group : groupList) {
            if (!authority.equals(group.getAuthority())) {
                this.logger.log(ChannelLogger.ChannelLogLevel.WARNING, "Multiple authorities found for LB. Skipping addresses for {0} in preference to {1}", new Object[]{group.getAuthority(), authority});
                continue;
            }
            eags.add(group.getAddresses());
        }
        Attributes attrs = Attributes.newBuilder().set(GrpcAttributes.ATTR_LB_ADDR_AUTHORITY, (Object)authority).build();
        return new LbAddressGroup(GrpclbState.flattenEquivalentAddressGroup(eags, attrs), authority);
    }

    private static EquivalentAddressGroup flattenEquivalentAddressGroup(List<EquivalentAddressGroup> groupList, Attributes attrs) {
        ArrayList addrs = new ArrayList();
        for (EquivalentAddressGroup group : groupList) {
            addrs.addAll(group.getAddresses());
        }
        return new EquivalentAddressGroup(addrs, attrs);
    }

    @VisibleForTesting
    static final class RoundRobinPicker
    extends LoadBalancer.SubchannelPicker {
        @VisibleForTesting
        final List<DropEntry> dropList;
        private int dropIndex;
        @VisibleForTesting
        final List<? extends RoundRobinEntry> pickList;
        private int pickIndex;

        RoundRobinPicker(List<DropEntry> dropList, List<? extends RoundRobinEntry> pickList) {
            this.dropList = (List)Preconditions.checkNotNull(dropList, (Object)"dropList");
            this.pickList = (List)Preconditions.checkNotNull(pickList, (Object)"pickList");
            Preconditions.checkArgument((!pickList.isEmpty() ? 1 : 0) != 0, (Object)"pickList is empty");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            List<? extends RoundRobinEntry> list = this.pickList;
            synchronized (list) {
                if (!this.dropList.isEmpty()) {
                    DropEntry drop = this.dropList.get(this.dropIndex);
                    ++this.dropIndex;
                    if (this.dropIndex == this.dropList.size()) {
                        this.dropIndex = 0;
                    }
                    if (drop != null) {
                        return drop.picked();
                    }
                }
                RoundRobinEntry pick = this.pickList.get(this.pickIndex);
                ++this.pickIndex;
                if (this.pickIndex == this.pickList.size()) {
                    this.pickIndex = 0;
                }
                return pick.picked(args.getHeaders());
            }
        }
    }

    @VisibleForTesting
    static final class ErrorEntry
    implements RoundRobinEntry {
        final LoadBalancer.PickResult result;

        ErrorEntry(Status status) {
            this.result = LoadBalancer.PickResult.withError((Status)status);
        }

        @Override
        public LoadBalancer.PickResult picked(Metadata headers) {
            return this.result;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.result});
        }

        public boolean equals(Object other) {
            if (!(other instanceof ErrorEntry)) {
                return false;
            }
            return Objects.equal((Object)this.result, (Object)((ErrorEntry)other).result);
        }

        public String toString() {
            return this.result.getStatus().toString();
        }
    }

    @VisibleForTesting
    static final class BackendEntry
    implements RoundRobinEntry {
        @VisibleForTesting
        final LoadBalancer.PickResult result;
        @Nullable
        private final GrpclbClientLoadRecorder loadRecorder;
        @Nullable
        private final String token;

        BackendEntry(LoadBalancer.Subchannel subchannel, GrpclbClientLoadRecorder loadRecorder, String token) {
            this.result = LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)subchannel, (ClientStreamTracer.Factory)loadRecorder);
            this.loadRecorder = (GrpclbClientLoadRecorder)((Object)Preconditions.checkNotNull((Object)((Object)loadRecorder), (Object)"loadRecorder"));
            this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"token");
        }

        BackendEntry(LoadBalancer.Subchannel subchannel) {
            this.result = LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)subchannel);
            this.loadRecorder = null;
            this.token = null;
        }

        @Override
        public LoadBalancer.PickResult picked(Metadata headers) {
            headers.discardAll(GrpclbConstants.TOKEN_METADATA_KEY);
            if (this.token != null) {
                headers.put(GrpclbConstants.TOKEN_METADATA_KEY, (Object)this.token);
            }
            return this.result;
        }

        public String toString() {
            return "[" + this.result.getSubchannel().getAllAddresses().toString() + "(" + this.token + ")]";
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.loadRecorder, this.result, this.token});
        }

        public boolean equals(Object other) {
            if (!(other instanceof BackendEntry)) {
                return false;
            }
            BackendEntry that = (BackendEntry)other;
            return Objects.equal((Object)this.result, (Object)that.result) && Objects.equal((Object)this.token, (Object)that.token) && Objects.equal((Object)((Object)this.loadRecorder), (Object)((Object)that.loadRecorder));
        }
    }

    private static interface RoundRobinEntry {
        public LoadBalancer.PickResult picked(Metadata var1);
    }

    @VisibleForTesting
    static final class DropEntry {
        private final GrpclbClientLoadRecorder loadRecorder;
        private final String token;

        DropEntry(GrpclbClientLoadRecorder loadRecorder, String token) {
            this.loadRecorder = (GrpclbClientLoadRecorder)((Object)Preconditions.checkNotNull((Object)((Object)loadRecorder), (Object)"loadRecorder"));
            this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"token");
        }

        LoadBalancer.PickResult picked() {
            this.loadRecorder.recordDroppedRequest(this.token);
            return DROP_PICK_RESULT;
        }

        public String toString() {
            return "drop(" + this.token + ")";
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.loadRecorder, this.token});
        }

        public boolean equals(Object other) {
            if (!(other instanceof DropEntry)) {
                return false;
            }
            DropEntry that = (DropEntry)other;
            return Objects.equal((Object)((Object)this.loadRecorder), (Object)((Object)that.loadRecorder)) && Objects.equal((Object)this.token, (Object)that.token);
        }
    }

    private class LbStream
    implements StreamObserver<LoadBalanceResponse> {
        final GrpclbClientLoadRecorder loadRecorder;
        final LoadBalancerGrpc.LoadBalancerStub stub;
        StreamObserver<LoadBalanceRequest> lbRequestWriter;
        boolean initialResponseReceived;
        boolean closed;
        long loadReportIntervalMillis = -1L;
        SynchronizationContext.ScheduledHandle loadReportTimer;

        LbStream(LoadBalancerGrpc.LoadBalancerStub stub) {
            this.stub = (LoadBalancerGrpc.LoadBalancerStub)((Object)Preconditions.checkNotNull((Object)((Object)stub), (Object)"stub"));
            this.loadRecorder = new GrpclbClientLoadRecorder(GrpclbState.this.time);
        }

        void start() {
            this.lbRequestWriter = ((LoadBalancerGrpc.LoadBalancerStub)this.stub.withWaitForReady()).balanceLoad(this);
        }

        public void onNext(final LoadBalanceResponse response) {
            GrpclbState.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    LbStream.this.handleResponse(response);
                }
            });
        }

        public void onError(final Throwable error) {
            GrpclbState.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    LbStream.this.handleStreamClosed(Status.fromThrowable((Throwable)error).augmentDescription("Stream to GRPCLB LoadBalancer had an error"));
                }
            });
        }

        public void onCompleted() {
            GrpclbState.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    LbStream.this.handleStreamClosed(Status.UNAVAILABLE.withDescription("Stream to GRPCLB LoadBalancer was closed"));
                }
            });
        }

        private void sendLoadReport() {
            if (this.closed) {
                return;
            }
            ClientStats stats = this.loadRecorder.generateLoadReport();
            try {
                this.lbRequestWriter.onNext((Object)LoadBalanceRequest.newBuilder().setClientStats(stats).build());
                this.scheduleNextLoadReport();
            }
            catch (Exception e) {
                this.close(e);
            }
        }

        private void scheduleNextLoadReport() {
            if (this.loadReportIntervalMillis > 0L) {
                this.loadReportTimer = GrpclbState.this.syncContext.schedule((Runnable)new LoadReportingTask(this), this.loadReportIntervalMillis, TimeUnit.MILLISECONDS, GrpclbState.this.timerService);
            }
        }

        private void handleResponse(LoadBalanceResponse response) {
            if (this.closed) {
                return;
            }
            GrpclbState.this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Got an LB response: {0}", new Object[]{response});
            LoadBalanceResponse.LoadBalanceResponseTypeCase typeCase = response.getLoadBalanceResponseTypeCase();
            if (!this.initialResponseReceived) {
                if (typeCase != LoadBalanceResponse.LoadBalanceResponseTypeCase.INITIAL_RESPONSE) {
                    GrpclbState.this.logger.log(ChannelLogger.ChannelLogLevel.WARNING, "Received a response without initial response");
                    return;
                }
                this.initialResponseReceived = true;
                InitialLoadBalanceResponse initialResponse = response.getInitialResponse();
                this.loadReportIntervalMillis = Durations.toMillis((Duration)initialResponse.getClientStatsReportInterval());
                this.scheduleNextLoadReport();
                return;
            }
            if (typeCase != LoadBalanceResponse.LoadBalanceResponseTypeCase.SERVER_LIST) {
                GrpclbState.this.logger.log(ChannelLogger.ChannelLogLevel.WARNING, "Ignoring unexpected response type: {0}", new Object[]{typeCase});
                return;
            }
            GrpclbState.this.balancerWorking = true;
            ServerList serverList = response.getServerList();
            ArrayList<DropEntry> newDropList = new ArrayList<DropEntry>();
            ArrayList<BackendAddressGroup> newBackendAddrList = new ArrayList<BackendAddressGroup>();
            for (Server server : serverList.getServersList()) {
                InetSocketAddress address;
                String token = server.getLoadBalanceToken();
                if (server.getDrop()) {
                    newDropList.add(new DropEntry(this.loadRecorder, token));
                    continue;
                }
                newDropList.add(null);
                try {
                    address = new InetSocketAddress(InetAddress.getByAddress(server.getIpAddress().toByteArray()), server.getPort());
                }
                catch (UnknownHostException e) {
                    GrpclbState.this.propagateError(Status.UNAVAILABLE.withDescription("Host for server not found: " + server).withCause((Throwable)e));
                    continue;
                }
                EquivalentAddressGroup eag = new EquivalentAddressGroup((SocketAddress)address, LB_PROVIDED_BACKEND_ATTRS);
                newBackendAddrList.add(new BackendAddressGroup(eag, token));
            }
            GrpclbState.this.usingFallbackBackends = false;
            GrpclbState.this.cancelFallbackTimer();
            GrpclbState.this.useRoundRobinLists(newDropList, newBackendAddrList, this.loadRecorder);
            GrpclbState.this.maybeUpdatePicker();
        }

        private void handleStreamClosed(Status error) {
            Preconditions.checkArgument((!error.isOk() ? 1 : 0) != 0, (Object)"unexpected OK status");
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.cleanUp();
            GrpclbState.this.propagateError(error);
            GrpclbState.this.balancerWorking = false;
            GrpclbState.this.maybeUseFallbackBackends();
            GrpclbState.this.maybeUpdatePicker();
            long delayNanos = 0L;
            if (this.initialResponseReceived || GrpclbState.this.lbRpcRetryPolicy == null) {
                GrpclbState.this.lbRpcRetryPolicy = GrpclbState.this.backoffPolicyProvider.get();
            }
            if (!this.initialResponseReceived) {
                delayNanos = GrpclbState.this.prevLbRpcStartNanos + GrpclbState.this.lbRpcRetryPolicy.nextBackoffNanos() - GrpclbState.this.time.currentTimeNanos();
            }
            if (delayNanos <= 0L) {
                GrpclbState.this.startLbRpc();
            } else {
                GrpclbState.this.lbRpcRetryTimer = GrpclbState.this.syncContext.schedule((Runnable)new LbRpcRetryTask(), delayNanos, TimeUnit.NANOSECONDS, GrpclbState.this.timerService);
            }
            GrpclbState.this.helper.refreshNameResolution();
        }

        void close(@Nullable Exception error) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.cleanUp();
            if (error == null) {
                this.lbRequestWriter.onCompleted();
            } else {
                this.lbRequestWriter.onError((Throwable)error);
            }
        }

        private void cleanUp() {
            if (this.loadReportTimer != null) {
                this.loadReportTimer.cancel();
                this.loadReportTimer = null;
            }
            if (GrpclbState.this.lbStream == this) {
                GrpclbState.this.lbStream = null;
            }
        }
    }

    @VisibleForTesting
    static class LoadReportingTask
    implements Runnable {
        private final LbStream stream;

        LoadReportingTask(LbStream stream) {
            this.stream = stream;
        }

        @Override
        public void run() {
            this.stream.loadReportTimer = null;
            this.stream.sendLoadReport();
        }
    }

    @VisibleForTesting
    class LbRpcRetryTask
    implements Runnable {
        LbRpcRetryTask() {
        }

        @Override
        public void run() {
            GrpclbState.this.startLbRpc();
        }
    }

    @VisibleForTesting
    class FallbackModeTask
    implements Runnable {
        FallbackModeTask() {
        }

        @Override
        public void run() {
            GrpclbState.this.maybeUseFallbackBackends();
            GrpclbState.this.maybeUpdatePicker();
        }
    }
}

