/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.imageview;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.imageview.AbstractImageViewer;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.IOUtils;

public class BrowserImageViewer
extends AbstractImageViewer {
    private static final Log log = Log.getLog(BrowserImageViewer.class);
    private Browser browser;
    private volatile boolean browserCreating;
    private Path tempFile;
    private ImageData imageData;

    /*
     * Unable to fully structure code
     */
    public BrowserImageViewer(Composite parent, int style) {
        block7: {
            super(parent, style);
            this.browserCreating = false;
            gl = new GridLayout(1, false);
            gl.horizontalSpacing = 0;
            gl.verticalSpacing = 0;
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            this.setLayout((Layout)gl);
            this.browserCreating = true;
            try {
                try {
                    this.browser = new Browser((Composite)this, 0);
                    break block7;
                }
                catch (SWTError error) {
                    if (error.code == 20) {
                        this.browser = null;
                        this.browser = new Browser((Composite)this, 65536);
                        break block7;
                    }
                    var8_5 = this.getChildren();
                    var7_6 = var8_5.length;
                    var6_7 = 0;
                    ** while (var6_7 < var7_6)
                }
lbl-1000:
                // 1 sources

                {
                    control = var8_5[var6_7];
                    control.dispose();
                    ++var6_7;
                    continue;
                }
lbl27:
                // 1 sources

                throw error;
            }
            finally {
                this.browserCreating = false;
            }
        }
        this.browser.setLayoutData((Object)new GridData(1808));
        this.browser.setJavascriptEnabled(false);
    }

    @Override
    public boolean loadImage(@NotNull InputStream inputStream) {
        boolean success = false;
        try {
            block14: {
                this.clearTempFile();
                try {
                    Throwable throwable = null;
                    Object var4_7 = null;
                    try (ImageInputStream stream = ImageIO.createImageInputStream(inputStream);){
                        Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
                        if (!readers.hasNext()) {
                            throw new IOException("No Image readers");
                        }
                        ImageReader reader = readers.next();
                        reader.setInput(stream);
                        this.tempFile = Files.createTempFile(DBWorkbench.getPlatform().getTempFolder((DBRProgressMonitor)new VoidProgressMonitor(), "dbeaver-images"), "image", "." + reader.getFormatName().toLowerCase(Locale.ROOT), new FileAttribute[0]);
                        ImageIO.write((RenderedImage)ImageIO.read(stream), reader.getFormatName().toLowerCase(Locale.ROOT), this.tempFile.toFile());
                        success = true;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException exception) {
                    if (exception.getMessage().equals("closed")) break block14;
                    log.error((Object)"Error reading image data", (Throwable)exception);
                    this.showBinaryTXT(inputStream);
                    success = false;
                }
            }
            URL url = this.tempFile.toUri().toURL();
            this.browser.setUrl(url.toString());
        }
        catch (IOException exception) {
            log.error((Object)exception);
        }
        return success;
    }

    private void showBinaryTXT(@NotNull InputStream inputStream) throws IOException {
        this.tempFile = Files.createTempFile(DBWorkbench.getPlatform().getTempFolder((DBRProgressMonitor)new VoidProgressMonitor(), "dbeaver-images"), "image", ".txt", new FileAttribute[0]);
        String s = IOUtils.readToString((Reader)new InputStreamReader(inputStream, GeneralUtils.DEFAULT_ENCODING));
        Files.writeString(this.tempFile, (CharSequence)s, new OpenOption[0]);
    }

    @Override
    public boolean clearImage() {
        this.clearTempFile();
        this.browser.setUrl(null);
        return true;
    }

    public void dispose() {
        this.clearTempFile();
        if (this.browser != null) {
            super.dispose();
        } else {
            new Job("Disposing browser"){

                protected IStatus run(IProgressMonitor monitor) {
                    while (BrowserImageViewer.this.browserCreating) {
                        Thread.onSpinWait();
                    }
                    UIUtils.syncExec(() -> BrowserImageViewer.access$0(BrowserImageViewer.this));
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private void clearTempFile() {
        if (this.tempFile != null && Files.exists(this.tempFile, new LinkOption[0])) {
            try {
                Files.delete(this.tempFile);
            }
            catch (IOException e) {
                log.warn((Object)e);
            }
        }
        this.tempFile = null;
    }

    static /* synthetic */ void access$0(BrowserImageViewer browserImageViewer) {
        super.dispose();
    }
}

