/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.ui;

import com.dbeaver.cloud.aws.AWSCloud;
import com.dbeaver.cloud.aws.AWSCloudConfiguration;
import com.dbeaver.cloud.aws.AWSCloudProvider;
import com.dbeaver.cloud.aws.AWSCloudUtils;
import com.dbeaver.cloud.aws.ui.internal.AwsCloudUIMessages;
import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.net.auth.aws.AuthModelAWSAbstract;
import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import com.dbeaver.ui.auth.aws.AuthModelAWSConfigurator;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.RunnableContextDelegate;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import software.amazon.awssdk.regions.Region;

public class AwsUIConfigurationEditor
implements IObjectPropertyConfigurator<Object, AWSCloudConfiguration> {
    private static final Log log = Log.getLog(AwsUIConfigurationEditor.class);
    private AWSCloudConfiguration curConfiguration;
    private AuthModelAWSConfigurator iamConfigurator;
    private CheckboxTreeViewer regionTreeViewer;
    private Composite mainGroup;
    private Button readAllRegionsCheckbox;
    private Button refreshSessionButton;
    private Button closeSessionButton;

    public void createControl(@NotNull Composite parent, Object object, @NotNull Runnable propertyChangeListener) {
        TabFolder configTabs = new TabFolder(parent, 0x800080);
        this.createGeneralTab(configTabs, propertyChangeListener);
        this.createRegionsTab(configTabs, propertyChangeListener);
        configTabs.setSelection(0);
    }

    public void createGeneralTab(final TabFolder parent, Runnable propertyChangeListener) {
        Composite topGroup = new Composite((Composite)parent, 0);
        topGroup.setLayout((Layout)new GridLayout(1, false));
        this.mainGroup = UIUtils.createComposite((Composite)topGroup, (int)2);
        this.mainGroup.setLayoutData((Object)new GridData(1808));
        this.iamConfigurator = new AuthModelAWSConfigurator();
        this.iamConfigurator.setCloudProvided(false);
        this.iamConfigurator.createIAMAuthControls(this.mainGroup, () -> {
            this.updateSessionActions();
            propertyChangeListener.run();
        }, false);
        this.iamConfigurator.initAuthTypes();
        this.readAllRegionsCheckbox = UIUtils.createCheckbox((Composite)this.mainGroup, (String)AwsCloudUIMessages.aws_configurator_checkbox_all_regions, (String)AwsCloudUIMessages.aws_configurator_checkbox_all_regions_tip, (boolean)true, (int)2);
        UIUtils.createEmptyLabel((Composite)topGroup, (int)1, (int)1).setLayoutData((Object)new GridData(1808));
        final Composite btnComposite = UIUtils.createComposite((Composite)topGroup, (int)4);
        btnComposite.setLayoutData((Object)new GridData(768));
        UIUtils.createEmptyLabel((Composite)btnComposite, (int)1, (int)1).setLayoutData((Object)new GridData(768));
        UIUtils.createDialogButton((Composite)btnComposite, (String)AwsCloudUIMessages.aws_configurator_dialog_button_test_connection, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AwsUIConfigurationEditor.this.saveSettings(AwsUIConfigurationEditor.this.curConfiguration);
                try {
                    AwsUIConfigurationEditor.this.getRunnableContext(parent).run(true, true, monitor -> AwsUIConfigurationEditor.this.testCloudConnection(monitor, AwsUIConfigurationEditor.this.curConfiguration));
                }
                catch (InvocationTargetException ex) {
                    DBWorkbench.getPlatformUI().showError("Cloud connect error", "Error during cloud connect", ex.getTargetException());
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        this.refreshSessionButton = UIUtils.createDialogButton((Composite)btnComposite, (String)AwsCloudUIMessages.aws_configurator_dialog_button_refresh_session, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AwsUIConfigurationEditor.this.saveSettings(AwsUIConfigurationEditor.this.curConfiguration);
                try {
                    AwsUIConfigurationEditor.this.getRunnableContext(parent).run(true, true, monitor -> AwsUIConfigurationEditor.this.refreshCloudSession(monitor, AwsUIConfigurationEditor.this.curConfiguration));
                }
                catch (InvocationTargetException ex) {
                    DBWorkbench.getPlatformUI().showError("Session refresh error", "Error during session refresh", ex.getTargetException());
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        this.closeSessionButton = UIUtils.createDialogButton((Composite)btnComposite, (String)AwsCloudUIMessages.aws_configurator_dialog_button_end_session, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!UIUtils.confirmAction((Shell)btnComposite.getShell(), (String)"End SSO Session", (String)"Are you sure you want to end active SSO session?")) {
                    return;
                }
                try {
                    AwsUIConfigurationEditor.this.getRunnableContext(parent).run(true, true, monitor -> AwsUIConfigurationEditor.this.closeCloudSession(monitor, AwsUIConfigurationEditor.this.curConfiguration));
                }
                catch (InvocationTargetException ex) {
                    DBWorkbench.getPlatformUI().showError("Session close error", "Error during session close", ex.getTargetException());
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        TabItem regionsTab = new TabItem(parent, 0);
        regionsTab.setText(AwsCloudUIMessages.aws_configurator_tab_item_authentication);
        regionsTab.setControl((Control)topGroup);
    }

    @NotNull
    public DBRRunnableContext getRunnableContext(TabFolder parent) {
        Object context = parent.getShell().getData() instanceof IRunnableContext ? new RunnableContextDelegate((IRunnableContext)parent.getShell().getData()) : UIUtils.getDialogRunnableContext();
        return context;
    }

    private void testCloudConnection(DBRProgressMonitor monitor, AWSCloudConfiguration cfg) throws InvocationTargetException {
        monitor.beginTask("Test AWS cloud connection", 1);
        AWSCloud cloud = new AWSCloudProvider().createCloudFromConfiguration((CPCloudConfiguration)cfg);
        cloud.getCloudConfiguration().setCloudId("aws-test-cloud");
        try {
            try {
                String response = cloud.testConnection(monitor);
                UIUtils.asyncExec(() -> UIUtils.showMessageBox(null, (String)AwsCloudUIMessages.aws_configurator_message_bog_title_success, (String)("Cloud connection established successfully: " + response), (int)2));
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
            UIUtils.asyncExec(this::updateSessionActions);
        }
    }

    private void refreshCloudSession(DBRProgressMonitor monitor, AWSCloudConfiguration cfg) throws InvocationTargetException {
        monitor.beginTask("Refresh AWS cloud connection", 1);
        AWSCloud cloud = new AWSCloudProvider().createCloudFromConfiguration((CPCloudConfiguration)cfg);
        try {
            try {
                String response = cloud.refreshSession(monitor);
                UIUtils.asyncExec(() -> UIUtils.showMessageBox(null, (String)AwsCloudUIMessages.aws_configurator_message_bog_title_success, (String)("Cloud session has been refreshed: " + response), (int)2));
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
            UIUtils.asyncExec(this::updateSessionActions);
        }
    }

    private void closeCloudSession(DBRProgressMonitor monitor, AWSCloudConfiguration cfg) throws InvocationTargetException {
        monitor.beginTask("Close AWS cloud connection", 1);
        AWSCloud cloud = new AWSCloudProvider().createCloudFromConfiguration((CPCloudConfiguration)cfg);
        try {
            try {
                cloud.closeSession(monitor);
                UIUtils.asyncExec(() -> UIUtils.showMessageBox(null, (String)AwsCloudUIMessages.aws_configurator_message_bog_title_success, (String)"Cloud session was terminated", (int)2));
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
            UIUtils.asyncExec(this::updateSessionActions);
        }
    }

    private void updateSessionActions() {
        boolean hasSessionToken = false;
        if (this.curConfiguration != null && this.iamConfigurator != null && this.iamConfigurator.isSSOEnabled()) {
            hasSessionToken = new AWSCloudProvider().createCloudFromConfiguration((CPCloudConfiguration)this.curConfiguration).getActiveSession() != null;
        }
        this.refreshSessionButton.setEnabled(hasSessionToken);
        this.closeSessionButton.setEnabled(hasSessionToken);
    }

    public void createRegionsTab(TabFolder parent, final Runnable propertyChangeListener) {
        Composite regionsGroup = UIUtils.createComposite((Composite)parent, (int)1);
        final Tree regionTree = new Tree(regionsGroup, 65572);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 300;
        regionTree.setLayoutData((Object)gd);
        UIUtils.createTreeColumn((Tree)regionTree, (int)16384, (String)AwsCloudUIMessages.aws_configurator_tree_column_region_id);
        UIUtils.createTreeColumn((Tree)regionTree, (int)16384, (String)AwsCloudUIMessages.aws_configurator_tree_column_region_name);
        List allRegions = AWSCloudUtils.getAllRegions(null);
        final LinkedHashMap<String, List> regionMap = new LinkedHashMap<String, List>();
        for (Region region : allRegions) {
            List subRegions = regionMap.computeIfAbsent(AWSCloudUtils.getSuperRegion((Region)region), rl -> new ArrayList());
            subRegions.add(region);
        }
        this.regionTreeViewer = new ContainerCheckedTreeViewer(regionTree);
        this.regionTreeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                return regionMap.keySet().toArray(new String[0]);
            }

            public Object[] getChildren(Object parentElement) {
                return regionMap.getOrDefault(parentElement, Collections.emptyList()).toArray();
            }

            @Nullable
            public Object getParent(Object element) {
                if (element instanceof Region) {
                    Region region = (Region)element;
                    return AWSCloudUtils.getSuperRegion((Region)region);
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return element instanceof String;
            }
        });
        this.regionTreeViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof String) {
                    String superRegion = (String)element;
                    cell.setText(superRegion);
                }
                if (!(element instanceof Region)) {
                    return;
                }
                Region region = (Region)element;
                if (cell.getColumnIndex() == 0) {
                    cell.setText(region.id());
                }
                if (cell.getColumnIndex() == 1) {
                    cell.setText(region.metadata().description());
                }
            }
        });
        this.regionTreeViewer.setInput(regionMap);
        this.regionTreeViewer.expandAll();
        TabItem regionsTab = new TabItem(parent, 0);
        regionsTab.setText(AwsCloudUIMessages.aws_configurator_tab_item_regions);
        regionsTab.setControl((Control)regionsGroup);
        regionTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                propertyChangeListener.run();
            }
        });
        parent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.packColumns((Tree)regionTree, (boolean)true, null);
            }
        });
    }

    public void loadSettings(@NotNull AWSCloudConfiguration configuration) {
        this.curConfiguration = configuration;
        this.mainGroup.setRedraw(false);
        try {
            LinkedHashMap authProperties = new LinkedHashMap();
            AuthModelAWSAbstract.saveCredentialsToMap((AuthModelAWSCredentials)configuration.getCredentials(), authProperties);
            this.iamConfigurator.loadIAMAuthSettings(authProperties);
            this.iamConfigurator.updateControls();
        }
        finally {
            this.mainGroup.setRedraw(true);
        }
        Set<String> defaultRegions = Set.of(configuration.getDefaultRegions());
        this.regionTreeViewer.setCheckedElements(Arrays.stream(this.regionTreeViewer.getTree().getItems()).flatMap(item -> Arrays.stream(item.getItems())).filter(treeItem -> treeItem.getData() instanceof Region).map(treeItem -> (Region)treeItem.getData()).filter(region -> defaultRegions.contains(region.id())).toArray());
        if (this.readAllRegionsCheckbox != null) {
            this.readAllRegionsCheckbox.setSelection(configuration.isReadAllRegions());
        }
        this.updateSessionActions();
    }

    public void saveSettings(@NotNull AWSCloudConfiguration configuration) {
        LinkedHashMap authProperties = new LinkedHashMap();
        this.iamConfigurator.saveIAMAuthSettings(authProperties);
        AuthModelAWSAbstract.loadCredentialsFromMap((AuthModelAWSCredentials)configuration.getCredentials(), authProperties);
        if (this.readAllRegionsCheckbox != null) {
            configuration.setReadAllRegions(this.readAllRegionsCheckbox.getSelection());
        }
        String[] defaultRegions = (String[])Arrays.stream(this.regionTreeViewer.getCheckedElements()).filter(o -> o instanceof Region).map(o -> (Region)o).map(Region::id).toArray(String[]::new);
        configuration.setDefaultRegions(defaultRegions);
    }

    public void resetSettings(@NotNull AWSCloudConfiguration configuration) {
    }

    public boolean isComplete() {
        return this.iamConfigurator.isComplete();
    }
}

