/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.editpolicies;

import java.util.List;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.Polyline;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.draw2dl.geometry.Translatable;
import org.eclipse.draw2dl.geometry.Transposer;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.GraphicalEditPart;
import org.eclipse.gef3.Request;
import org.eclipse.gef3.editpolicies.OrderedLayoutEditPolicy;
import org.eclipse.gef3.requests.DropRequest;

public abstract class FlowLayoutEditPolicy
extends OrderedLayoutEditPolicy {
    private Polyline insertionLine;

    @Override
    protected void eraseLayoutTargetFeedback(Request request) {
        if (this.insertionLine != null) {
            this.removeFeedback((IFigure)this.insertionLine);
            this.insertionLine = null;
        }
    }

    private Rectangle getAbsoluteBounds(GraphicalEditPart ep) {
        Rectangle bounds = ep.getFigure().getBounds().getCopy();
        ep.getFigure().translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    protected int getFeedbackIndexFor(Request request) {
        List children = this.getHost().getChildren();
        if (children.isEmpty()) {
            return -1;
        }
        Transposer transposer = new Transposer();
        transposer.setEnabled(!this.isLayoutHorizontal());
        Point p = transposer.t(this.getLocationFromRequest(request));
        int rowBottom = Integer.MIN_VALUE;
        int candidate = -1;
        int i = 0;
        while (i < children.size()) {
            EditPart child = (EditPart)children.get(i);
            Rectangle rect = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)child));
            if (rect.y > rowBottom) {
                if (p.y <= rowBottom) {
                    if (candidate != -1) break;
                    candidate = i;
                    break;
                }
                candidate = -1;
            }
            rowBottom = Math.max(rowBottom, rect.bottom());
            if (candidate == -1 && p.x <= rect.x + rect.width / 2) {
                candidate = i;
            }
            if (candidate != -1 && p.y <= rowBottom) break;
            ++i;
        }
        return candidate;
    }

    @Override
    protected EditPart getInsertionReference(Request request) {
        List children = this.getHost().getChildren();
        if (request.getType().equals("create child")) {
            int i = this.getFeedbackIndexFor(request);
            if (i == -1) {
                return null;
            }
            return (EditPart)children.get(i);
        }
        int index = this.getFeedbackIndexFor(request);
        if (index != -1) {
            List selection = this.getHost().getViewer().getSelectedEditParts();
            do {
                EditPart editpart;
                if (selection.contains(editpart = (EditPart)children.get(index))) continue;
                return editpart;
            } while (++index < children.size());
        }
        return null;
    }

    protected Polyline getLineFeedback() {
        if (this.insertionLine == null) {
            this.insertionLine = new Polyline();
            this.insertionLine.setLineWidth(2);
            this.insertionLine.addPoint(new Point(0, 0));
            this.insertionLine.addPoint(new Point(10, 10));
            this.addFeedback((IFigure)this.insertionLine);
        }
        return this.insertionLine;
    }

    private Point getLocationFromRequest(Request request) {
        return ((DropRequest)((Object)request)).getLocation();
    }

    protected boolean isHorizontal() {
        return this.isLayoutHorizontal();
    }

    @Override
    protected void showLayoutTargetFeedback(Request request) {
        Rectangle parentBox;
        EditPart editPart;
        if (this.getHost().getChildren().size() == 0) {
            return;
        }
        Polyline fb = this.getLineFeedback();
        Transposer transposer = new Transposer();
        transposer.setEnabled(!this.isLayoutHorizontal());
        boolean before = true;
        int epIndex = this.getFeedbackIndexFor(request);
        Rectangle r = null;
        if (epIndex == -1) {
            before = false;
            epIndex = this.getHost().getChildren().size() - 1;
            editPart = (EditPart)this.getHost().getChildren().get(epIndex);
            r = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)editPart));
        } else {
            editPart = (EditPart)this.getHost().getChildren().get(epIndex);
            r = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)editPart));
            Point p = transposer.t(this.getLocationFromRequest(request));
            if (p.x <= r.x + r.width / 2) {
                before = true;
            } else {
                before = false;
                editPart = (EditPart)this.getHost().getChildren().get(--epIndex);
                r = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)editPart));
            }
        }
        int x = Integer.MIN_VALUE;
        if (before) {
            if (epIndex > 0) {
                Rectangle boxPrev = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)this.getHost().getChildren().get(epIndex - 1)));
                int prevRight = boxPrev.right();
                if (prevRight < r.x) {
                    x = prevRight + (r.x - prevRight) / 2;
                } else if (prevRight == r.x) {
                    x = prevRight + 1;
                }
            }
            if (x == Integer.MIN_VALUE) {
                parentBox = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)this.getHost()));
                x = r.x - 5;
                if (x < parentBox.x) {
                    x = parentBox.x + (r.x - parentBox.x) / 2;
                }
            }
        } else {
            parentBox = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)this.getHost()));
            int rRight = r.x + r.width;
            x = rRight + 5;
            int pRight = parentBox.x + parentBox.width;
            if (x > pRight) {
                x = rRight + (pRight - rRight) / 2;
            }
        }
        Point p1 = new Point(x, r.y - 4);
        p1 = transposer.t(p1);
        fb.translateToRelative((Translatable)p1);
        Point p2 = new Point(x, r.y + r.height + 4);
        p2 = transposer.t(p2);
        fb.translateToRelative((Translatable)p2);
        fb.setPoint(p1, 0);
        fb.setPoint(p2, 1);
    }
}

