/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.ui.handlers;

import com.dbeaver.ee.mockdata.ui.MockDataGenerateTool;
import com.dbeaver.ee.mockdata.ui.internal.MockDataUIMessages;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSDocumentContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.handler.ResultSetHandlerMain;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;

public class ResultSetMockDataHandler
extends AbstractHandler {
    private static final Log log = Log.getLog(ResultSetMockDataHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ArrayList<DBSObject> selectedObjects;
        IResultSetController resultSet = ResultSetHandlerMain.getActiveResultSet((IWorkbenchPart)HandlerUtil.getActivePart((ExecutionEvent)event));
        if (resultSet != null) {
            DBSDataContainer dataContainer = resultSet.getDataContainer();
            if (dataContainer == null || dataContainer.getDataSource() == null) {
                DBWorkbench.getPlatformUI().showError(MockDataUIMessages.tools_mockdata_message_title, MockDataUIMessages.tools_mockdata_error_notconnected);
                return null;
            }
            if (!(dataContainer instanceof DBSDataManipulator)) {
                DBWorkbench.getPlatformUI().showError(MockDataUIMessages.tools_mockdata_message_title, MockDataUIMessages.tools_mockdata_error_tableonly);
                return null;
            }
            selectedObjects = new ArrayList<DBSObject>();
            selectedObjects.add((DBSObject)dataContainer);
            if (dataContainer.isFeatureSupported("data.key.value") || dataContainer instanceof DBSDocumentContainer) {
                DBWorkbench.getPlatformUI().showError(MockDataUIMessages.tools_mockdata_message_title, MockDataUIMessages.tools_mockdata_error_table_type_not_supported);
                return null;
            }
        } else {
            selectedObjects = NavigatorUtils.getSelectedObjects((ISelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        }
        MockDataGenerateTool mockDataGenerator = new MockDataGenerateTool();
        try {
            mockDataGenerator.execute(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), null, selectedObjects);
        }
        catch (DBException e) {
            log.error((Object)"Error launching the Mock Data Generator", (Throwable)e);
        }
        return null;
    }
}

