/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.ui;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.IWizardPageNavigable;

public class MockDataWizardPageLog
extends WizardPage
implements IWizardPageNavigable {
    private static final Log log = Log.getLog(MockDataWizardPageLog.class);
    private MessageConsole console;
    private OutputStreamWriter writer;

    public MockDataWizardPageLog(String task) {
        super(task);
        this.setTitle("Progress");
        this.setDescription("Mock data generation progress log");
    }

    public boolean isPageComplete() {
        return true;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new FillLayout());
        this.console = new MessageConsole("mock-data-log-console", null);
        new LogConsoleViewer(composite);
        this.console.setWaterMarks(0x300000, 0x400000);
        this.writer = new OutputStreamWriter((OutputStream)this.console.newMessageStream(), StandardCharsets.UTF_8);
        this.setControl((Control)composite);
    }

    void appendLog(String line) {
        this.appendLog(line, false);
    }

    void appendLog(String line, boolean error) {
        if (this.getShell().isDisposed()) {
            return;
        }
        try {
            this.writer.write(line);
            this.writer.flush();
        }
        catch (IOException e) {
            log.debug((Object)e);
        }
    }

    public void clearLog() {
        if (this.getShell().isDisposed()) {
            return;
        }
        UIUtils.syncExec(() -> {
            MockDataWizardPageLog mockDataWizardPageLog = this;
            synchronized (mockDataWizardPageLog) {
                this.console.clearConsole();
            }
        });
    }

    public boolean isPageNavigable() {
        return false;
    }

    public boolean isPageApplicable() {
        return true;
    }

    private class LogConsoleViewer
    extends TextConsoleViewer
    implements IDocumentListener {
        LogConsoleViewer(Composite composite) {
            super(composite, (TextConsole)MockDataWizardPageLog.this.console);
        }

        public void setDocument(IDocument document) {
            IDocument oldDocument = this.getDocument();
            super.setDocument(document);
            if (oldDocument != null) {
                oldDocument.removeDocumentListener((IDocumentListener)this);
            }
            if (document != null) {
                document.addDocumentListener((IDocumentListener)this);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            this.revealEndOfDocument();
        }
    }
}

