/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.ui;

import com.dbeaver.ee.mockdata.engine.model.MockGeneratorDescriptor;
import com.dbeaver.ee.mockdata.engine.model.MockGeneratorRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class EntityProperties {
    private static final String PROP_REMOVE_OLD_DATA = "removeOldData";
    private static final String PROP_ROWS_NUMBER = "rowsNumber";
    private static final String PROP_BATCH_SIZE = "batchSize";
    private static final String KEY_SELECTED_ATTRIBUTE = "selectedAttribute";
    private static final String KEY_SELECTED_GENERATOR = "selectedGenerator";
    private static final String KEY_PRESET_ID = "presetId";
    private static final String KEY_GENERATOR_SECTION = "GENERATOR_SECTION";
    static final String NO_GENERATOR_ID = "<no generator>";
    private final Map<String, MockGeneratorDescriptor> generatorDescriptors = new HashMap<String, MockGeneratorDescriptor>();
    private final Map<String, AttributeProperties> attributeGenerators = new HashMap<String, AttributeProperties>();
    private final Collection<DBSAttributeBase> attributes = new ArrayList<DBSAttributeBase>();
    private final DBSObject inputObject;
    private final DBSDataManipulator dataManipulator;
    private final DBSEntity entity;
    @Nullable
    private String selectedAttribute;
    private boolean removeOldData;
    private long rowsNumber = 1000L;
    private int batchSize = 200;

    EntityProperties(@NotNull DBSObject inputObject) {
        this.inputObject = inputObject;
        this.dataManipulator = (DBSDataManipulator)inputObject;
        this.entity = (DBSEntity)inputObject;
    }

    public void init(DBRProgressMonitor monitor) throws DBException {
        for (DBSAttributeBase attr : CommonUtils.safeCollection((Collection)this.entity.getAttributes(monitor))) {
            if (DBUtils.isPseudoAttribute((DBSAttributeBase)attr) || DBUtils.isHiddenObject((Object)attr)) continue;
            this.attributes.add(attr);
        }
        MockGeneratorRegistry generatorRegistry = MockGeneratorRegistry.getInstance();
        for (DBSAttributeBase attribute : this.attributes) {
            AttributeProperties generatorProperties = new AttributeProperties(attribute);
            this.attributeGenerators.put(attribute.getName(), generatorProperties);
            List attributeReferrers = DBUtils.getAttributeReferrers((DBRProgressMonitor)monitor, (DBSEntityAttribute)((DBSEntityAttribute)attribute), (boolean)true);
            if (!CommonUtils.isEmpty((Collection)attributeReferrers)) {
                MockGeneratorDescriptor generator = generatorRegistry.getGenerator("fkGenerator");
                this.putGenerator(generatorProperties, generator);
                continue;
            }
            List generators = generatorRegistry.findAllGenerators(this.dataManipulator.getDataSource(), (DBSTypedObject)attribute);
            for (MockGeneratorDescriptor generator : generators) {
                this.putGenerator(generatorProperties, generator);
            }
        }
    }

    DBSObject getInputObject() {
        return this.inputObject;
    }

    DBSDataManipulator getDataManipulator() {
        return this.dataManipulator;
    }

    DBSEntity getEntity() {
        return this.entity;
    }

    Collection<DBSAttributeBase> getAttributes() {
        return this.attributes;
    }

    @Nullable
    String getSelectedAttribute() {
        return this.selectedAttribute;
    }

    void setSelectedAttribute(@Nullable String selectedAttribute) {
        this.selectedAttribute = selectedAttribute;
    }

    private void putGenerator(AttributeProperties generatorProperties, MockGeneratorDescriptor generator) {
        this.generatorDescriptors.put(generator.getId(), generator);
        generatorProperties.putGeneratorProperties(generator.getId(), new PropertySourceCustom((Collection)generator.getProperties(), null));
    }

    public MockGeneratorDescriptor getGeneratorDescriptor(String generatorId) {
        return this.generatorDescriptors.get(generatorId);
    }

    @Nullable
    public MockGeneratorDescriptor findGeneratorForName(DBSAttributeBase attribute, String generatorName) {
        AttributeProperties attributeGeneratorProperties = this.attributeGenerators.get(attribute.getName());
        for (String generatorId : attributeGeneratorProperties.getGenerators()) {
            MockGeneratorDescriptor generatorDescriptor = this.generatorDescriptors.get(generatorId);
            if (!generatorName.equals(generatorDescriptor.getLabel())) continue;
            return generatorDescriptor;
        }
        return null;
    }

    public boolean isRemoveOldData() {
        return this.removeOldData;
    }

    public void setRemoveOldData(boolean removeOldData) {
        this.removeOldData = removeOldData;
    }

    public long getRowsNumber() {
        return this.rowsNumber;
    }

    public void setRowsNumber(long rowsNumber) {
        this.rowsNumber = rowsNumber;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public Map<String, AttributeProperties> getAttributeGenerators() {
        return this.attributeGenerators;
    }

    public AttributeProperties getAttributeProperties(@NotNull DBSAttributeBase attribute) {
        return this.attributeGenerators.get(attribute.getName());
    }

    private IDialogSettings getEntitySettings(@NotNull IDialogSettings dialogSettings) {
        return UIUtils.getSettingsSection((IDialogSettings)dialogSettings, (String)(String.valueOf(this.entity.getDataSource().getName()) + "." + DBUtils.getObjectFullName((DBPDataSource)this.entity.getDataSource(), (DBPNamedObject)this.entity, (DBPEvaluationContext)DBPEvaluationContext.DML)));
    }

    public void loadFrom(@NotNull DBRProgressMonitor monitor, @NotNull IDialogSettings dialogSettings) {
        IDialogSettings entitySettings = this.getEntitySettings(dialogSettings);
        this.removeOldData = entitySettings.getBoolean(PROP_REMOVE_OLD_DATA);
        try {
            this.rowsNumber = entitySettings.getInt(PROP_ROWS_NUMBER);
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            this.batchSize = entitySettings.getInt(PROP_BATCH_SIZE);
        }
        catch (NumberFormatException numberFormatException) {}
        this.selectedAttribute = entitySettings.get(KEY_SELECTED_ATTRIBUTE);
        for (Map.Entry<String, AttributeProperties> entry : this.attributeGenerators.entrySet()) {
            String attributeName = entry.getKey();
            IDialogSettings attributeSection = UIUtils.getSettingsSection((IDialogSettings)entitySettings, (String)attributeName);
            String savedGeneratorId = attributeSection.get(KEY_SELECTED_GENERATOR);
            AttributeProperties attrGeneratorProperties = entry.getValue();
            if (NO_GENERATOR_ID.equals(savedGeneratorId)) {
                attrGeneratorProperties.setSelectedGenerator(null);
                attrGeneratorProperties.setPresetId(null);
                continue;
            }
            if (!CommonUtils.isEmpty((String)savedGeneratorId)) {
                MockGeneratorDescriptor generatorDescriptor = attrGeneratorProperties.getGenerator(savedGeneratorId);
                if (generatorDescriptor != null) {
                    attrGeneratorProperties.setSelectedGenerator(generatorDescriptor);
                    attrGeneratorProperties.setPresetId(attributeSection.get(KEY_PRESET_ID));
                }
                PropertySourceCustom generatorPropertySource = attrGeneratorProperties.getGeneratorProperties();
                IDialogSettings generatorSection = UIUtils.getSettingsSection((IDialogSettings)attributeSection, (String)KEY_GENERATOR_SECTION);
                if (generatorPropertySource == null) continue;
                DBPPropertyDescriptor[] dBPPropertyDescriptorArray = generatorPropertySource.getProperties();
                int n = dBPPropertyDescriptorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DBPPropertyDescriptor prop = dBPPropertyDescriptorArray[n2];
                    String key = prop.getId();
                    Object savedValue = UIUtils.getSectionValueWithType((IDialogSettings)generatorSection, (String)key);
                    if (!key.equals("nulls") || !(savedValue instanceof Boolean)) {
                        generatorPropertySource.setPropertyValue(monitor, key, savedValue);
                    }
                    ++n2;
                }
                continue;
            }
            this.autoAssignGenerator(attrGeneratorProperties);
        }
    }

    public void autoAssignGenerator(AttributeProperties attrGeneratorProperties) {
        DBSAttributeBase attribute = attrGeneratorProperties.getAttribute();
        if (attribute.isAutoGenerated()) {
            attrGeneratorProperties.setSelectedGenerator(null);
            return;
        }
        String attributeName = attribute.getName().toLowerCase();
        Set<String> attrGeneratorIds = attrGeneratorProperties.getGenerators();
        boolean found = false;
        for (String generatorId : attrGeneratorIds) {
            MockGeneratorDescriptor generatorDescriptor = this.getGeneratorDescriptor(generatorId);
            for (String tag : generatorDescriptor.getTags()) {
                if (!attributeName.contains(tag)) continue;
                attrGeneratorProperties.setSelectedGenerator(generatorDescriptor);
                found = true;
                break;
            }
            if (found) break;
        }
        if (!found) {
            if (attrGeneratorIds.contains("fkGenerator")) {
                this.setSelectedGenerator(attrGeneratorProperties, "fkGenerator");
                return;
            }
            switch (attribute.getDataKind()) {
                case BOOLEAN: {
                    this.setSelectedGenerator(attrGeneratorProperties, "booleanRandomGenerator");
                    break;
                }
                case DATETIME: {
                    this.setSelectedGenerator(attrGeneratorProperties, "dateRandomGenerator");
                    break;
                }
                case NUMERIC: {
                    this.setSelectedGenerator(attrGeneratorProperties, "numericAdvancedGenerator");
                    break;
                }
                case STRING: {
                    this.setSelectedGenerator(attrGeneratorProperties, "stringTextGenerator");
                }
            }
        }
    }

    private void setSelectedGenerator(@NotNull AttributeProperties attrGeneratorProperties, @Nullable String generatorId) {
        if (generatorId == null) {
            attrGeneratorProperties.setSelectedGenerator(null);
        } else {
            attrGeneratorProperties.setSelectedGenerator(attrGeneratorProperties.getGenerator(generatorId));
        }
    }

    void saveTo(@NotNull IDialogSettings dialogSettings) {
        IDialogSettings entitySettings = this.getEntitySettings(dialogSettings);
        entitySettings.put(PROP_REMOVE_OLD_DATA, this.removeOldData);
        entitySettings.put(PROP_ROWS_NUMBER, this.rowsNumber);
        entitySettings.put(PROP_BATCH_SIZE, this.batchSize);
        entitySettings.put(KEY_SELECTED_ATTRIBUTE, this.selectedAttribute);
        for (Map.Entry<String, AttributeProperties> attrEntry : this.attributeGenerators.entrySet()) {
            String attributeName = attrEntry.getKey();
            AttributeProperties attrGeneratorProperties = attrEntry.getValue();
            IDialogSettings attributeSection = UIUtils.getSettingsSection((IDialogSettings)entitySettings, (String)attributeName);
            MockGeneratorDescriptor selectedGenerator = attrGeneratorProperties.getSelectedGenerator();
            if (selectedGenerator == null) {
                attributeSection.put(KEY_SELECTED_GENERATOR, NO_GENERATOR_ID);
                attributeSection.put(KEY_PRESET_ID, null);
                continue;
            }
            attributeSection.put(KEY_SELECTED_GENERATOR, selectedGenerator.getId());
            attributeSection.put(KEY_PRESET_ID, attrGeneratorProperties.getPresetId());
            IDialogSettings generatorSection = UIUtils.getSettingsSection((IDialogSettings)attributeSection, (String)KEY_GENERATOR_SECTION);
            PropertySourceCustom generatorPropertySource = attrGeneratorProperties.getGeneratorProperties();
            if (generatorPropertySource == null) continue;
            Map properties = generatorPropertySource.getPropertiesWithDefaults();
            for (Map.Entry propEntry : properties.entrySet()) {
                UIUtils.putSectionValueWithType((IDialogSettings)generatorSection, (String)((String)propEntry.getKey()), propEntry.getValue());
            }
        }
    }

    class AttributeProperties {
        private final Map<String, PropertySourceCustom> generators = new TreeMap<String, PropertySourceCustom>();
        private final DBSAttributeBase attribute;
        @Nullable
        private MockGeneratorDescriptor selectedGenerator;
        @Nullable
        private String presetId;

        public AttributeProperties(DBSAttributeBase attribute) {
            this.attribute = attribute;
        }

        public DBSAttributeBase getAttribute() {
            return this.attribute;
        }

        @Nullable
        public MockGeneratorDescriptor getSelectedGenerator() {
            return this.selectedGenerator;
        }

        public Set<String> getGenerators() {
            return this.generators.keySet();
        }

        public void setSelectedGenerator(@Nullable MockGeneratorDescriptor generator) {
            this.selectedGenerator = generator;
        }

        public void putGeneratorProperties(String generatorId, PropertySourceCustom propertySource) {
            this.generators.put(generatorId, propertySource);
        }

        public PropertySourceCustom getGeneratorProperties() {
            return this.selectedGenerator == null ? null : this.generators.get(this.selectedGenerator.getId());
        }

        @Nullable
        public String getPresetId() {
            return this.presetId;
        }

        public void setPresetId(@Nullable String presetId) {
            this.presetId = presetId;
        }

        public boolean isEmpty() {
            return this.generators.isEmpty();
        }

        public MockGeneratorDescriptor getGenerator(String generatorId) {
            return EntityProperties.this.generatorDescriptors.get(generatorId);
        }
    }
}

