/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.document.exec;

import com.dbeaver.model.document.exec.DocumentReadStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCResultSetSampleProvider;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.AbstractResultSet;
import org.jkiss.dbeaver.model.impl.local.LocalResultSetMeta;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;

public abstract class DocumentResultSet<SESSION extends DBCSession, STATEMENT extends DBCStatement>
extends AbstractResultSet<SESSION, STATEMENT>
implements DBCResultSetSampleProvider {
    private DBCResultSetMetaData metaData;
    protected int itemNumber = -1;

    public DocumentResultSet(STATEMENT statement) {
        super(statement.getSession(), statement);
    }

    public DBSEntity getSourceEntity() {
        if (this.statement instanceof DocumentReadStatement) {
            return ((DocumentReadStatement)this.statement).getSourceEntity();
        }
        return null;
    }

    protected String getSourceSchemaName() {
        DBSSchema schema;
        DBSEntity sourceEntity = this.getSourceEntity();
        if (sourceEntity != null && (schema = (DBSSchema)DBUtils.getParentOfType(DBSSchema.class, (DBSObject)sourceEntity)) != null) {
            return schema.getName();
        }
        return null;
    }

    protected String getSourceCatalogName() {
        DBSCatalog catalog;
        DBSEntity sourceEntity = this.getSourceEntity();
        if (sourceEntity != null && (catalog = (DBSCatalog)DBUtils.getParentOfType(DBSCatalog.class, (DBSObject)sourceEntity)) != null) {
            return catalog.getName();
        }
        return null;
    }

    protected String getSourceEntityName() {
        DBSEntity sourceEntity = this.getSourceEntity();
        return sourceEntity == null ? null : sourceEntity.getName();
    }

    protected void checkRowFetched() throws DBCException {
        if (this.itemNumber < 0) {
            throw new DBCException("Row not fetched");
        }
    }

    public boolean moveTo(int position) throws DBCException {
        this.itemNumber = position - 1;
        return true;
    }

    @NotNull
    public DBCResultSetMetaData getMeta() throws DBCException {
        if (this.metaData == null) {
            this.metaData = new LocalResultSetMeta(Collections.singletonList(new DynamicDocumentAttribute()));
        }
        return this.metaData;
    }

    public String getResultSetName() throws DBCException {
        return null;
    }

    public Object getFeature(String name) {
        return null;
    }

    public void close() {
    }

    private DBCEntityMetaData makeEntityMetaData(DBCAttributeMetaData attributeMeta) {
        return new DocumentEntityMetaData(attributeMeta);
    }

    @NotNull
    public List<Object[]> getSampleRows(DBCSession session, int maxRows) throws DBCException {
        ArrayList<Object[]> sample = new ArrayList<Object[]>();
        while (this.nextRow() && maxRows-- > 0 && !session.getProgressMonitor().isCanceled()) {
            sample.add(new Object[]{this.getAttributeValue(0)});
        }
        this.moveTo(0);
        return sample;
    }

    private class DocumentEntityMetaData
    implements DBCEntityMetaData {
        private final DBCAttributeMetaData attributeMeta;

        DocumentEntityMetaData(DBCAttributeMetaData attributeMeta) {
            this.attributeMeta = attributeMeta;
        }

        public String getCatalogName() {
            return DocumentResultSet.this.getSourceCatalogName();
        }

        public String getSchemaName() {
            return DocumentResultSet.this.getSourceSchemaName();
        }

        @NotNull
        public String getEntityName() {
            return DocumentResultSet.this.getSourceEntityName();
        }

        @NotNull
        public List<? extends DBCAttributeMetaData> getAttributes() {
            return Collections.singletonList(this.attributeMeta);
        }

        public String toString() {
            return this.getEntityName();
        }
    }

    public class DynamicDocumentAttribute
    implements DBCAttributeMetaData {
        public String getFullTypeName() {
            return this.getTypeName();
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isAutoGenerated() {
            return false;
        }

        public Integer getScale() {
            return 0;
        }

        public Integer getPrecision() {
            return 0;
        }

        public long getMaxLength() {
            return 0L;
        }

        public long getTypeModifiers() {
            return 0L;
        }

        public boolean isReadOnly() {
            return false;
        }

        public DBCEntityMetaData getEntityMetaData() {
            return DocumentResultSet.this.makeEntityMetaData(this);
        }

        @NotNull
        public String getName() {
            return "##document";
        }

        public String getTypeName() {
            return "json";
        }

        public int getTypeID() {
            return 0;
        }

        public DBPDataKind getDataKind() {
            return DBPDataKind.DOCUMENT;
        }

        public int getOrdinalPosition() {
            return 0;
        }

        public Object getSource() {
            return DocumentResultSet.this.statement;
        }

        @NotNull
        public String getLabel() {
            return this.getName();
        }

        public String getEntityName() {
            return DocumentResultSet.this.getSourceEntityName();
        }

        public String toString() {
            return this.getName();
        }
    }
}

