/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase.exec;

import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.query.N1qlQueryRow;
import com.dbeaver.db.couchbase.data.CouchbaseDocument;
import com.dbeaver.db.couchbase.exec.CouchbaseQueryStatementN1;
import com.dbeaver.db.couchbase.exec.CouchbaseSession;
import com.dbeaver.model.document.exec.DocumentResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;

public class CouchbaseResultSetN1
extends DocumentResultSet<CouchbaseSession, CouchbaseQueryStatementN1> {
    private final Iterator<N1qlQueryRow> results;
    private List<JsonObject> lastItems;
    private long totalItems;
    private long limit;

    public CouchbaseResultSetN1(CouchbaseQueryStatementN1 statement, Iterator<N1qlQueryRow> results, long limit) {
        super((DBCStatement)statement);
        this.results = results;
        this.limit = limit;
        this.lastItems = null;
    }

    @NotNull
    private Object createDocument(JsonObject valueMap) {
        return new CouchbaseDocument(((CouchbaseSession)this.getSession()).getDataSource(), valueMap);
    }

    public Object getAttributeValue(int index) throws DBCException {
        this.checkRowFetched();
        JsonObject valueMap = this.lastItems.get(this.itemNumber);
        if (index == 0) {
            return this.createDocument(valueMap);
        }
        throw new DBCException("Index out of range (" + index + ")");
    }

    public Object getAttributeValue(String name) throws DBCException {
        this.checkRowFetched();
        return this.createDocument(this.lastItems.get(this.itemNumber));
    }

    public boolean nextRow() throws DBCException {
        if (this.limit > 0L && this.totalItems >= this.limit) {
            return false;
        }
        if (this.lastItems == null && !this.fetchNextSegment()) {
            return false;
        }
        if (this.lastItems != null && this.lastItems.size() - 1 > this.itemNumber) {
            ++this.itemNumber;
            ++this.totalItems;
            return true;
        }
        return false;
    }

    protected String getSourceEntityName() {
        return ((CouchbaseQueryStatementN1)this.statement).getEntityName();
    }

    public boolean moveTo(int position) throws DBCException {
        if (!this.fetchNextSegment()) {
            return false;
        }
        if (position < 0 || position >= this.lastItems.size()) {
            return false;
        }
        this.itemNumber = position;
        return true;
    }

    @NotNull
    public List<Object[]> getSampleRows(DBCSession session, int maxRows) throws DBCException {
        if (this.lastItems == null && !this.fetchNextSegment()) {
            return Collections.emptyList();
        }
        ArrayList<Object[]> sample = new ArrayList<Object[]>();
        for (JsonObject doc : this.lastItems) {
            sample.add(new Object[]{this.createDocument(doc)});
        }
        return sample;
    }

    private boolean fetchNextSegment() {
        this.lastItems = new ArrayList<JsonObject>();
        while (this.results.hasNext()) {
            N1qlQueryRow row = this.results.next();
            this.lastItems.add(row.value());
        }
        return true;
    }
}

