/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.subscription.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.subscription.SubscriptionManager;
import com.azure.resourcemanager.subscription.fluent.TenantsClient;
import com.azure.resourcemanager.subscription.fluent.models.TenantIdDescriptionInner;
import com.azure.resourcemanager.subscription.implementation.TenantIdDescriptionImpl;
import com.azure.resourcemanager.subscription.implementation.Utils;
import com.azure.resourcemanager.subscription.models.TenantIdDescription;
import com.azure.resourcemanager.subscription.models.Tenants;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class TenantsImpl
implements Tenants {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(TenantsImpl.class);
    private final TenantsClient innerClient;
    private final SubscriptionManager serviceManager;

    public TenantsImpl(TenantsClient innerClient, SubscriptionManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<TenantIdDescription> list() {
        PagedIterable<TenantIdDescriptionInner> inner = this.serviceClient().list();
        return Utils.mapPage(inner, inner1 -> new TenantIdDescriptionImpl((TenantIdDescriptionInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<TenantIdDescription> list(Context context) {
        PagedIterable<TenantIdDescriptionInner> inner = this.serviceClient().list(context);
        return Utils.mapPage(inner, inner1 -> new TenantIdDescriptionImpl((TenantIdDescriptionInner)inner1, this.manager()));
    }

    private TenantsClient serviceClient() {
        return this.innerClient;
    }

    private SubscriptionManager manager() {
        return this.serviceManager;
    }
}

