/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.subscription.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.subscription.fluent.SubscriptionOperationsClient;
import com.azure.resourcemanager.subscription.fluent.models.CanceledSubscriptionIdInner;
import com.azure.resourcemanager.subscription.fluent.models.EnabledSubscriptionIdInner;
import com.azure.resourcemanager.subscription.fluent.models.RenamedSubscriptionIdInner;
import com.azure.resourcemanager.subscription.implementation.SubscriptionClientImpl;
import com.azure.resourcemanager.subscription.models.SubscriptionName;
import reactor.core.publisher.Mono;

public final class SubscriptionOperationsClientImpl
implements SubscriptionOperationsClient {
    private final ClientLogger logger = new ClientLogger(SubscriptionOperationsClientImpl.class);
    private final SubscriptionOperationsService service;
    private final SubscriptionClientImpl client;

    SubscriptionOperationsClientImpl(SubscriptionClientImpl client) {
        this.service = (SubscriptionOperationsService)RestProxy.create(SubscriptionOperationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<Response<CanceledSubscriptionIdInner>> cancelWithResponseAsync(String subscriptionId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cancel(this.client.getEndpoint(), subscriptionId, "2020-09-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<CanceledSubscriptionIdInner>> cancelWithResponseAsync(String subscriptionId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.cancel(this.client.getEndpoint(), subscriptionId, "2020-09-01", "application/json", context);
    }

    private Mono<CanceledSubscriptionIdInner> cancelAsync(String subscriptionId) {
        return this.cancelWithResponseAsync(subscriptionId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CanceledSubscriptionIdInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public CanceledSubscriptionIdInner cancel(String subscriptionId) {
        return (CanceledSubscriptionIdInner)this.cancelAsync(subscriptionId).block();
    }

    @Override
    public Response<CanceledSubscriptionIdInner> cancelWithResponse(String subscriptionId, Context context) {
        return (Response)this.cancelWithResponseAsync(subscriptionId, context).block();
    }

    private Mono<Response<RenamedSubscriptionIdInner>> renameWithResponseAsync(String subscriptionId, SubscriptionName body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.rename(this.client.getEndpoint(), subscriptionId, "2020-09-01", body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<RenamedSubscriptionIdInner>> renameWithResponseAsync(String subscriptionId, SubscriptionName body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.rename(this.client.getEndpoint(), subscriptionId, "2020-09-01", body, "application/json", context);
    }

    private Mono<RenamedSubscriptionIdInner> renameAsync(String subscriptionId, SubscriptionName body) {
        return this.renameWithResponseAsync(subscriptionId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((RenamedSubscriptionIdInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public RenamedSubscriptionIdInner rename(String subscriptionId, SubscriptionName body) {
        return (RenamedSubscriptionIdInner)this.renameAsync(subscriptionId, body).block();
    }

    @Override
    public Response<RenamedSubscriptionIdInner> renameWithResponse(String subscriptionId, SubscriptionName body, Context context) {
        return (Response)this.renameWithResponseAsync(subscriptionId, body, context).block();
    }

    private Mono<Response<EnabledSubscriptionIdInner>> enableWithResponseAsync(String subscriptionId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.enable(this.client.getEndpoint(), subscriptionId, "2020-09-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<EnabledSubscriptionIdInner>> enableWithResponseAsync(String subscriptionId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.enable(this.client.getEndpoint(), subscriptionId, "2020-09-01", "application/json", context);
    }

    private Mono<EnabledSubscriptionIdInner> enableAsync(String subscriptionId) {
        return this.enableWithResponseAsync(subscriptionId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((EnabledSubscriptionIdInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public EnabledSubscriptionIdInner enable(String subscriptionId) {
        return (EnabledSubscriptionIdInner)this.enableAsync(subscriptionId).block();
    }

    @Override
    public Response<EnabledSubscriptionIdInner> enableWithResponse(String subscriptionId, Context context) {
        return (Response)this.enableWithResponseAsync(subscriptionId, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SubscriptionClientSu")
    private static interface SubscriptionOperationsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Subscription/cancel")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CanceledSubscriptionIdInner>> cancel(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Subscription/rename")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RenamedSubscriptionIdInner>> rename(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") SubscriptionName var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Subscription/enable")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EnabledSubscriptionIdInner>> enable(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

