/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.subscription.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.subscription.SubscriptionManager;
import com.azure.resourcemanager.subscription.fluent.AliasClient;
import com.azure.resourcemanager.subscription.fluent.models.PutAliasListResultInner;
import com.azure.resourcemanager.subscription.fluent.models.PutAliasResponseInner;
import com.azure.resourcemanager.subscription.implementation.PutAliasListResultImpl;
import com.azure.resourcemanager.subscription.implementation.PutAliasResponseImpl;
import com.azure.resourcemanager.subscription.models.Alias;
import com.azure.resourcemanager.subscription.models.PutAliasListResult;
import com.azure.resourcemanager.subscription.models.PutAliasRequest;
import com.azure.resourcemanager.subscription.models.PutAliasResponse;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class AliasImpl
implements Alias {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AliasImpl.class);
    private final AliasClient innerClient;
    private final SubscriptionManager serviceManager;

    public AliasImpl(AliasClient innerClient, SubscriptionManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PutAliasResponse create(String aliasName, PutAliasRequest body) {
        PutAliasResponseInner inner = this.serviceClient().create(aliasName, body);
        if (inner != null) {
            return new PutAliasResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PutAliasResponse create(String aliasName, PutAliasRequest body, Context context) {
        PutAliasResponseInner inner = this.serviceClient().create(aliasName, body, context);
        if (inner != null) {
            return new PutAliasResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PutAliasResponse get(String aliasName) {
        PutAliasResponseInner inner = this.serviceClient().get(aliasName);
        if (inner != null) {
            return new PutAliasResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<PutAliasResponse> getWithResponse(String aliasName, Context context) {
        Response<PutAliasResponseInner> inner = this.serviceClient().getWithResponse(aliasName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PutAliasResponseImpl((PutAliasResponseInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public void delete(String aliasName) {
        this.serviceClient().delete(aliasName);
    }

    @Override
    public Response<Void> deleteWithResponse(String aliasName, Context context) {
        return this.serviceClient().deleteWithResponse(aliasName, context);
    }

    @Override
    public PutAliasListResult list() {
        PutAliasListResultInner inner = this.serviceClient().list();
        if (inner != null) {
            return new PutAliasListResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<PutAliasListResult> listWithResponse(Context context) {
        Response<PutAliasListResultInner> inner = this.serviceClient().listWithResponse(context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PutAliasListResultImpl((PutAliasListResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    private AliasClient serviceClient() {
        return this.innerClient;
    }

    private SubscriptionManager manager() {
        return this.serviceManager;
    }
}

