/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.translator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.ai.translator.DAIHistoryItem;
import org.jkiss.dbeaver.model.ai.translator.DAIHistoryManager;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class SimpleFilterManager
implements DAIHistoryManager {
    private static final Map<String, List<DAIHistoryItem>> queryHistory = new HashMap<String, List<DAIHistoryItem>>();

    @Override
    @NotNull
    public List<DAIHistoryItem> readTranslationHistory(@NotNull DBRProgressMonitor monitor, @NotNull DBSLogicalDataSource dataSource, @NotNull DBCExecutionContext executionContext, int maxCount) {
        List<DAIHistoryItem> queries = queryHistory.get(dataSource.getDataSourceContainer().getId());
        if (!CommonUtils.isEmpty(queries)) {
            return new ArrayList<DAIHistoryItem>(queries);
        }
        return Collections.emptyList();
    }

    @Override
    public void saveTranslationHistory(@NotNull DBRProgressMonitor monitor, @NotNull DBSLogicalDataSource dataSource, @NotNull DBCExecutionContext executionContext, @NotNull String natualText, @NotNull String sqlText) {
        List queries = queryHistory.computeIfAbsent(dataSource.getDataSourceContainer().getId(), k -> new ArrayList());
        DAIHistoryItem item = new DAIHistoryItem(natualText, sqlText);
        item.setTime(new Date());
        queries.add(item);
    }
}

