/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.ServerProperties;
import com.azure.resourcemanager.postgresqlflexibleserver.models.AuthConfig;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Backup;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CreateMode;
import com.azure.resourcemanager.postgresqlflexibleserver.models.DataEncryption;
import com.azure.resourcemanager.postgresqlflexibleserver.models.HighAvailability;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MaintenanceWindow;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Network;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ReplicationRole;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerState;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerVersion;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Sku;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Storage;
import com.azure.resourcemanager.postgresqlflexibleserver.models.UserAssignedIdentity;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

public final class ServerInner
extends Resource {
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="identity")
    private UserAssignedIdentity identity;
    @JsonProperty(value="properties")
    private ServerProperties innerProperties;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    public Sku sku() {
        return this.sku;
    }

    public ServerInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public UserAssignedIdentity identity() {
        return this.identity;
    }

    public ServerInner withIdentity(UserAssignedIdentity identity) {
        this.identity = identity;
        return this;
    }

    private ServerProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public ServerInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ServerInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String administratorLogin() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLogin();
    }

    public ServerInner withAdministratorLogin(String administratorLogin) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withAdministratorLogin(administratorLogin);
        return this;
    }

    public String administratorLoginPassword() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLoginPassword();
    }

    public ServerInner withAdministratorLoginPassword(String administratorLoginPassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    public ServerVersion version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public ServerInner withVersion(ServerVersion version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    public String minorVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minorVersion();
    }

    public ServerState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public String fullyQualifiedDomainName() {
        return this.innerProperties() == null ? null : this.innerProperties().fullyQualifiedDomainName();
    }

    public Storage storage() {
        return this.innerProperties() == null ? null : this.innerProperties().storage();
    }

    public ServerInner withStorage(Storage storage) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withStorage(storage);
        return this;
    }

    public AuthConfig authConfig() {
        return this.innerProperties() == null ? null : this.innerProperties().authConfig();
    }

    public ServerInner withAuthConfig(AuthConfig authConfig) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withAuthConfig(authConfig);
        return this;
    }

    public DataEncryption dataEncryption() {
        return this.innerProperties() == null ? null : this.innerProperties().dataEncryption();
    }

    public ServerInner withDataEncryption(DataEncryption dataEncryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withDataEncryption(dataEncryption);
        return this;
    }

    public Backup backup() {
        return this.innerProperties() == null ? null : this.innerProperties().backup();
    }

    public ServerInner withBackup(Backup backup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withBackup(backup);
        return this;
    }

    public Network network() {
        return this.innerProperties() == null ? null : this.innerProperties().network();
    }

    public ServerInner withNetwork(Network network) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withNetwork(network);
        return this;
    }

    public HighAvailability highAvailability() {
        return this.innerProperties() == null ? null : this.innerProperties().highAvailability();
    }

    public ServerInner withHighAvailability(HighAvailability highAvailability) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withHighAvailability(highAvailability);
        return this;
    }

    public MaintenanceWindow maintenanceWindow() {
        return this.innerProperties() == null ? null : this.innerProperties().maintenanceWindow();
    }

    public ServerInner withMaintenanceWindow(MaintenanceWindow maintenanceWindow) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withMaintenanceWindow(maintenanceWindow);
        return this;
    }

    public String sourceServerResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceServerResourceId();
    }

    public ServerInner withSourceServerResourceId(String sourceServerResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withSourceServerResourceId(sourceServerResourceId);
        return this;
    }

    public OffsetDateTime pointInTimeUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().pointInTimeUtc();
    }

    public ServerInner withPointInTimeUtc(OffsetDateTime pointInTimeUtc) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withPointInTimeUtc(pointInTimeUtc);
        return this;
    }

    public String availabilityZone() {
        return this.innerProperties() == null ? null : this.innerProperties().availabilityZone();
    }

    public ServerInner withAvailabilityZone(String availabilityZone) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withAvailabilityZone(availabilityZone);
        return this;
    }

    public ReplicationRole replicationRole() {
        return this.innerProperties() == null ? null : this.innerProperties().replicationRole();
    }

    public ServerInner withReplicationRole(ReplicationRole replicationRole) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withReplicationRole(replicationRole);
        return this;
    }

    public Integer replicaCapacity() {
        return this.innerProperties() == null ? null : this.innerProperties().replicaCapacity();
    }

    public ServerInner withReplicaCapacity(Integer replicaCapacity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withReplicaCapacity(replicaCapacity);
        return this;
    }

    public CreateMode createMode() {
        return this.innerProperties() == null ? null : this.innerProperties().createMode();
    }

    public ServerInner withCreateMode(CreateMode createMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withCreateMode(createMode);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

