/*
 * Decompiled with CFR 0.152.
 */
package com.edb.jms.client;

import com.edb.jms.client.EDBJmsMessageListener;
import com.edb.jms.client.EDBJmsSession;
import com.edb.jms.message.EDBMessageImpl;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

public class EDBJmsMessageConsumer
implements EDBJmsMessageListener,
MessageConsumer {
    private EDBJmsSession _session = null;
    private final long _consumerId;
    private final Destination _destination;
    private MessageListener _listener = null;
    private String _selector = null;
    private volatile boolean _closed = false;
    private static final Logger _log = Logger.getLogger(EDBJmsMessageConsumer.class.getName());

    public EDBJmsMessageConsumer(EDBJmsSession session, long consumerId, Destination destination, String selector) {
        if (session == null) {
            throw new IllegalArgumentException("Argument 'session' is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Argument 'destination' is null");
        }
        this._session = session;
        this._consumerId = consumerId;
        this._destination = destination;
        this._selector = selector;
    }

    @Override
    public String getMessageSelector() {
        return this._selector;
    }

    @Override
    public MessageListener getMessageListener() {
        return this._listener;
    }

    @Override
    public void setMessageListener(MessageListener listener) throws JMSException {
        if (listener != null) {
            this._listener = this._listener == null ? listener : listener;
        } else if (this._listener != null) {
            this._listener = listener;
        }
    }

    @Override
    public Message receive() throws JMSException {
        return this._session.receive(this.getDestination());
    }

    @Override
    public Message receive(long timeout) throws JMSException {
        this.checkReceive();
        return null;
    }

    @Override
    public Message receiveNoWait() throws JMSException {
        this.checkReceive();
        return null;
    }

    @Override
    public synchronized void close() throws JMSException {
        if (!this._closed) {
            try {
                this._closed = true;
                this.notifyAll();
            }
            finally {
                this._listener = null;
                this._session = null;
                this._selector = null;
            }
        }
    }

    @Override
    public boolean onMessage(EDBMessageImpl message) {
        boolean delivered = false;
        try {
            if (this._listener != null) {
                this._listener.onMessage(message);
                delivered = true;
            } else {
                _log.log(Level.SEVERE, "NessageListener no longer registered");
            }
        }
        catch (Throwable exception) {
            _log.log(Level.SEVERE, "MessageListener threw exception", exception);
        }
        return delivered;
    }

    @Override
    public void onMessageAvailable() throws RemoteException {
    }

    protected Destination getDestination() {
        return this._destination;
    }

    protected long getConsumerId() {
        return this._consumerId;
    }

    protected EDBJmsSession getSession() {
        return this._session;
    }

    private void checkReceive() throws JMSException {
        if (this._listener != null) {
            throw new JMSException("Can't receive when listener defined");
        }
        if (this._closed) {
            throw new JMSException("Can't receive when session closed");
        }
    }
}

