/*
 * Decompiled with CFR 0.152.
 */
package com.edb.jms.client;

import com.edb.jms.client.EDBJmsSession;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;

public class EDBJmsConnection
implements javax.jms.Connection {
    private String _host;
    private int _port;
    private String _database;
    private String _user;
    private String _password;
    private Connection _conn;

    protected EDBJmsConnection(String host, int port, String database, String username, String password) throws JMSException {
        this._host = host;
        this._port = port;
        this._database = database;
        this._user = username;
        this._password = password;
    }

    @Override
    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        Connection conn = this.createConnection(this._host, this._port, this._database, this._user, this._password);
        this.setConn(conn);
        EDBJmsSession session = new EDBJmsSession(conn, transacted, acknowledgeMode);
        return session;
    }

    private Connection createConnection(String hostname, int port, String database, String username, String password) throws JMSException {
        if (this._conn == null) {
            try {
                Class.forName("com.edb.Driver");
                this.setConn(DriverManager.getConnection("jdbc:edb://" + hostname + ":" + port + "/" + database, username, password));
            }
            catch (ClassNotFoundException exception) {
                throw new JMSException("Failed to create connection: " + exception.getMessage());
            }
            catch (Exception exception) {
                throw new JMSException("Failed to create proxy: " + exception);
            }
        }
        return this._conn;
    }

    @Override
    public Session createSession(int arg0) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Session createSession() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getClientID() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClientID(String arg0) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ConnectionMetaData getMetaData() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ExceptionListener getExceptionListener() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setExceptionListener(ExceptionListener arg0) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void start() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void stop() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void close() throws JMSException {
        try {
            this._conn.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(EDBJmsConnection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public ConnectionConsumer createConnectionConsumer(Destination arg0, String arg1, ServerSessionPool arg2, int arg3) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ConnectionConsumer createSharedConnectionConsumer(Topic arg0, String arg1, String arg2, ServerSessionPool arg3, int arg4) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ConnectionConsumer createDurableConnectionConsumer(Topic arg0, String arg1, String arg2, ServerSessionPool arg3, int arg4) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic arg0, String arg1, String arg2, ServerSessionPool arg3, int arg4) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Connection getConn() {
        return this._conn;
    }

    public void setConn(Connection _conn) {
        this._conn = _conn;
    }
}

