/*
 * Decompiled with CFR 0.152.
 */
package nl.knaw.dans.common.dbflib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import nl.knaw.dans.common.dbflib.Field;
import nl.knaw.dans.common.dbflib.Type;
import nl.knaw.dans.common.dbflib.Util;
import nl.knaw.dans.common.dbflib.Value;
import nl.knaw.dans.common.dbflib.ValueTooLargeException;

public class StringValue
extends Value {
    private final String charsetName;
    static final int MAX_CHARFIELD_LENGTH_DBASE = 253;

    public StringValue(String stringValue, String charsetName) {
        super(stringValue);
        this.charsetName = charsetName;
        Charset.forName(charsetName);
    }

    public StringValue(String stringValue) {
        this(stringValue, Charset.defaultCharset().name());
    }

    StringValue(Field field, byte[] rawValue, String charsetName) {
        super(field, rawValue);
        this.charsetName = charsetName == null ? Charset.defaultCharset().name() : charsetName;
    }

    @Override
    protected Object doGetTypedValue(byte[] rawValue) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(rawValue.length);
        for (int i = 0; i < rawValue.length; ++i) {
            if (StringValue.lookingAtSoftReturn(rawValue, i)) {
                ++i;
                continue;
            }
            bos.write(rawValue[i]);
        }
        return Util.createString(bos.toByteArray(), this.charsetName);
    }

    private static boolean lookingAtSoftReturn(byte[] buffer, int index) {
        return index < buffer.length - 1 && buffer[index] == -115 && buffer[index + 1] == 10;
    }

    @Override
    protected byte[] doGetRawValue(Field field) throws ValueTooLargeException {
        int fieldLength = field.getLength();
        byte[] stringBytes = Util.getStringBytes((String)this.typed, this.charsetName);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(fieldLength);
        try {
            byteArrayOutputStream.write(stringBytes);
            if (field.getType() != Type.MEMO) {
                byteArrayOutputStream.write(Util.repeat((byte)0, fieldLength - stringBytes.length));
            }
        }
        catch (IOException ioException) {
            assert (false) : "Writing to ByteArrayOutputStream should not cause an IOException";
            throw new RuntimeException(ioException);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

