/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.sched.system.win;

import com.dbeaver.ee.sched.system.BaseSystemScheduler;
import com.dbeaver.ee.sched.system.GenericTaskScheduleInfo;
import com.dbeaver.model.win32.com.ICollection;
import com.dbeaver.model.win32.com.IRegisteredTask;
import com.dbeaver.model.win32.com.IRegistrationInfo;
import com.dbeaver.model.win32.com.ITaskDefinition;
import com.dbeaver.model.win32.com.ITaskFolder;
import com.dbeaver.model.win32.com.ITaskService;
import com.dbeaver.model.win32.com.TaskCreationFlags;
import com.dbeaver.model.win32.com.TaskDayOfMonth;
import com.dbeaver.model.win32.com.TaskDayOfWeek;
import com.dbeaver.model.win32.com.TaskLogon;
import com.dbeaver.model.win32.com.TaskMonthOfYear;
import com.dbeaver.model.win32.com.action.IAction;
import com.dbeaver.model.win32.com.action.IActionCollection;
import com.dbeaver.model.win32.com.action.IActionExecute;
import com.dbeaver.model.win32.com.trigger.IDailyTrigger;
import com.dbeaver.model.win32.com.trigger.IMonthlyTrigger;
import com.dbeaver.model.win32.com.trigger.ITrigger;
import com.dbeaver.model.win32.com.trigger.ITriggerCollection;
import com.dbeaver.model.win32.com.trigger.IWeeklyTrigger;
import com.sun.jna.platform.win32.COM.COMException;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.task.DBTScheduler;
import org.jkiss.dbeaver.model.task.DBTSchedulerExternalSettings;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleConfiguration;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleInfo;
import org.jkiss.dbeaver.registry.timezone.TimezoneRegistry;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class COMSystemScheduler
extends BaseSystemScheduler {
    private static final Log log = Log.getLog(COMSystemScheduler.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final String DEFAULT_FOLDER = "DBeaver";
    private static final Pattern TASK_NAME_PATTERN = Pattern.compile("^.*\\(([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})\\)$");
    private final Map<String, GenericTaskScheduleInfo> registeredTasks = new LinkedHashMap<String, GenericTaskScheduleInfo>();
    private final ITaskService service = new ITaskService();
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$dbeaver$model$win32$com$trigger$ITrigger$Type;

    public COMSystemScheduler() throws DBException {
        try {
            this.service.connect(null, null, null, null);
        }
        catch (COMException e) {
            throw new DBException("Error connecting to the task scheduler service", (Throwable)e);
        }
    }

    @NotNull
    public String getSchedulerName() {
        return "Local Windows Task Scheduler";
    }

    public boolean supportsFeature(String feature) {
        switch (feature) {
            case "frequency.daily": 
            case "frequency.monthly.last_day": 
            case "frequency.monthly.startDate": 
            case "frequency.minutely.recurrence.greaterThan59": 
            case "frequency.minutely.startDatetime": 
            case "frequency.onetime": 
            case "frequency.weekly.startDate": 
            case "frequency.minutely": 
            case "frequency.hourly.recurrence.greaterThan23": 
            case "frequency.daily.recurrence": 
            case "frequency.daily.recurrence.greaterThan31": 
            case "frequency.hourly": 
            case "frequency.daily.startDate": 
            case "frequency.monthly": 
            case "frequency.weekly": 
            case "frequency.weekly.recurrence": 
            case "frequency.onetime.startDatetime": 
            case "frequency.hourly.startDatetime": {
                return true;
            }
        }
        return false;
    }

    public DBTScheduler.RecurrenceType getRecurrenceType() {
        return DBTScheduler.RecurrenceType.Interval;
    }

    @NotNull
    public List<DBTTaskScheduleInfo> getAllScheduledTasks() {
        return new ArrayList<DBTTaskScheduleInfo>(this.registeredTasks.values());
    }

    @Nullable
    public DBTTaskScheduleInfo getScheduledTaskInfo(@NotNull DBTTask task) {
        GenericTaskScheduleInfo info = this.registeredTasks.get(task.getName());
        if (info != null) {
            return info;
        }
        return this.registeredTasks.get(task.getId());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public DBTTaskScheduleConfiguration getScheduledTaskConfiguration(@NotNull DBTTask task) {
        block79: {
            configuration = new DBTTaskScheduleConfiguration();
            var4_3 = null;
            var5_8 = null;
            try {
                block77: {
                    block78: {
                        registeredTask = COMSystemScheduler.findRegisteredTask(this.getTasksFolder(), task);
                        if (registeredTask == null) {
                            if (registeredTask == null) return null;
                            registeredTask.close();
                            return null;
                        }
                        {
                            var7_16 = null;
                            var8_18 = null;
                            try {
                                definition = registeredTask.getDefinition();
                                var10_23 = null;
                                var11_25 = null;
                                try {
                                    block76: {
                                        triggers = definition.getTriggers();
                                        if (triggers.getCount() < 1) {
                                            COMSystemScheduler.log.error((Object)("Cannot find triggers for task '" + task.getName() + "'"));
                                            if (triggers == null) break block76;
                                        }
                                        ** GOTO lbl-1000
                                        triggers.close();
                                    }
                                    if (definition != null) {
                                        definition.close();
                                    }
                                    if (registeredTask == null) return null;
                                    registeredTask.close();
                                    return null;
                                }
                                catch (Throwable var11_26) {
                                    if (var10_23 == null) {
                                        var10_23 = var11_26;
                                        throw var10_23;
                                    }
                                    if (var10_23 == var11_26) throw var10_23;
                                    var10_23.addSuppressed(var11_26);
                                    throw var10_23;
                                }
                            }
                            catch (Throwable var8_19) {
                                if (var7_16 == null) {
                                    var7_16 = var8_19;
                                    throw var7_16;
                                }
                                if (var7_16 == var8_19) throw var7_16;
                                var7_16.addSuppressed(var8_19);
                                throw var7_16;
                            }
                            catch (Throwable var7_17) {
                                throw var7_17;
                            }
                        }
lbl-1000:
                        // 1 sources

                        {
                            trigger = (ITrigger)triggers.getItem(0);
                            startBoundary = trigger.getStartBoundary();
                            if (startBoundary != null) break block77;
                            COMSystemScheduler.log.error((Object)("Missing start boundary of trigger for task '" + task.getName() + "'"));
                            if (triggers == null) break block78;
                        }
                        triggers.close();
                    }
                    if (definition != null) {
                        definition.close();
                    }
                    if (registeredTask == null) return null;
                    registeredTask.close();
                    return null;
                }
                ** try [egrp 10[TRYBLOCK] [15 : 226->365)] { 
lbl68:
                // 1 sources

                ** try [egrp 14[TRYBLOCK] [2 : 226->247)] { 
lbl69:
                // 1 sources

                configuration.startTime = Date.from(startBoundary.atZone(ZoneId.of(TimezoneRegistry.getUserDefaultTimezone())).toInstant());
                break block79;
lbl71:
                // 1 sources

                finally {
                    if (triggers != null) {
                        triggers.close();
                    }
                }
lbl75:
                // 1 sources

                finally {
                    if (registeredTask != null) {
                        registeredTask.close();
                    }
                }
            }
            catch (Throwable var5_9) {
                if (var4_3 == null) {
                    var4_3 = var5_9;
                    throw var4_3;
                }
                if (var4_3 == var5_9) throw var4_3;
                var4_3.addSuppressed(var5_9);
                throw var4_3;
            }
        }
        switch (COMSystemScheduler.$SWITCH_TABLE$com$dbeaver$model$win32$com$trigger$ITrigger$Type()[trigger.getType().ordinal()]) {
            case 1: {
                var5_8 = null;
                registeredTask = null;
                try {
                    timeTrigger = trigger.asTimeTrigger();
                    try {
                        var8_18 = null;
                        var9_21 = null;
                        try {
                            repetition = timeTrigger.getRepetition();
                            try {
                                interval = repetition.getInterval();
                            }
                            finally {
                                if (repetition != null) {
                                    repetition.close();
                                }
                            }
                        }
                        catch (Throwable var9_22) {
                            if (var8_18 == null) {
                                var8_18 = var9_22;
                                throw var8_18;
                            }
                            if (var8_18 == var9_22) throw var8_18;
                            var8_18.addSuppressed(var9_22);
                            throw var8_18;
                        }
                    }
                    finally {
                        if (timeTrigger != null) {
                            timeTrigger.close();
                        }
                    }
                }
                catch (Throwable registeredTask) {
                    if (var5_8 == null) {
                        var5_8 = registeredTask;
                        throw var5_8;
                    }
                    if (var5_8 == registeredTask) throw var5_8;
                    var5_8.addSuppressed(registeredTask);
                    throw var5_8;
                }
                if (interval == null) {
                    configuration.frequency = DBTTaskScheduleConfiguration.Frequency.ONE_TIME;
                    return configuration;
                }
                if (interval.toHours() > 0L) {
                    configuration.frequency = DBTTaskScheduleConfiguration.Frequency.HOURLY;
                    configuration.recurrence = (int)interval.toHours();
                    return configuration;
                }
                configuration.frequency = DBTTaskScheduleConfiguration.Frequency.MINUTELY;
                configuration.recurrence = (int)interval.toMinutes();
                return configuration;
            }
            case 2: {
                var4_3 = null;
                var5_8 = null;
                try {
                    dailyTrigger = trigger.asDailyTrigger();
                    try {
                        configuration.frequency = DBTTaskScheduleConfiguration.Frequency.DAILY;
                        configuration.recurrence = dailyTrigger.getDaysInterval();
                        return configuration;
                    }
                    finally {
                        if (dailyTrigger != null) {
                            dailyTrigger.close();
                        }
                    }
                }
                catch (Throwable var5_11) {
                    if (var4_3 == null) {
                        var4_3 = var5_11;
                        throw var4_3;
                    }
                    if (var4_3 == var5_11) throw var4_3;
                    var4_3.addSuppressed(var5_11);
                    throw var4_3;
                }
            }
            case 3: {
                var4_3 = null;
                var5_8 = null;
                try {
                    weeklyTrigger = trigger.asWeeklyTrigger();
                    try {
                        configuration.frequency = DBTTaskScheduleConfiguration.Frequency.WEEKLY;
                        configuration.recurrence = weeklyTrigger.getWeeksInterval();
                        configuration.days = weeklyTrigger.getDaysOfWeek().stream().map((Function<TaskDayOfWeek, Short>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$0(com.dbeaver.model.win32.com.TaskDayOfWeek ), (Lcom/dbeaver/model/win32/com/TaskDayOfWeek;)Ljava/lang/Short;)()).collect(Collectors.toList());
                        return configuration;
                    }
                    finally {
                        if (weeklyTrigger != null) {
                            weeklyTrigger.close();
                        }
                    }
                }
                catch (Throwable var5_12) {
                    if (var4_3 == null) {
                        var4_3 = var5_12;
                        throw var4_3;
                    }
                    if (var4_3 == var5_12) throw var4_3;
                    var4_3.addSuppressed(var5_12);
                    throw var4_3;
                }
            }
            case 4: {
                var4_3 = null;
                var5_8 = null;
                try {
                    monthlyTrigger = trigger.asMonthlyTrigger();
                    try {
                        configuration.frequency = DBTTaskScheduleConfiguration.Frequency.MONTHLY;
                        configuration.days = monthlyTrigger.getDaysOfMonth().stream().map((Function<TaskDayOfMonth, Short>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$1(com.dbeaver.model.win32.com.TaskDayOfMonth ), (Lcom/dbeaver/model/win32/com/TaskDayOfMonth;)Ljava/lang/Short;)()).collect(Collectors.toList());
                        configuration.months = monthlyTrigger.getMonthsOfYear().stream().map((Function<TaskMonthOfYear, Short>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$2(com.dbeaver.model.win32.com.TaskMonthOfYear ), (Lcom/dbeaver/model/win32/com/TaskMonthOfYear;)Ljava/lang/Short;)()).collect(Collectors.toList());
                        if (monthlyTrigger.isRunOnLastDayOfMonth() == false) return configuration;
                        configuration.days.add((short)32);
                        return configuration;
                    }
                    finally {
                        if (monthlyTrigger != null) {
                            monthlyTrigger.close();
                        }
                    }
                }
                catch (Throwable var5_13) {
                    if (var4_3 == null) {
                        var4_3 = var5_13;
                        throw var4_3;
                    }
                    if (var4_3 == var5_13) throw var4_3;
                    var4_3.addSuppressed(var5_13);
                    throw var4_3;
                }
            }
        }
        COMSystemScheduler.log.error((Object)("Unsupported trigger type: " + trigger.getType()));
        trigger.release();
        return null;
    }

    public void setTaskSchedule(@NotNull DBTTask task, @NotNull DBTTaskScheduleConfiguration configuration) throws DBException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ITaskDefinition definition = this.service.newTask();){
            Throwable throwable2;
            Throwable throwable3;
            Throwable throwable4 = null;
            Object var7_14 = null;
            try (IRegistrationInfo registrationInfo = definition.getRegistrationInfo();){
                registrationInfo.setDescription(GeneralUtils.getProductName());
                registrationInfo.setVersion(GeneralUtils.getProductVersion().toString());
            }
            catch (Throwable throwable5) {
                if (throwable4 == null) {
                    throwable4 = throwable5;
                } else if (throwable4 != throwable5) {
                    throwable4.addSuppressed(throwable5);
                }
                throw throwable4;
            }
            throwable4 = null;
            var7_14 = null;
            try (ITriggerCollection triggers = definition.getTriggers();){
                LocalDateTime startBoundary = configuration.startTime.toInstant().atZone(ZoneId.of(TimezoneRegistry.getUserDefaultTimezone())).toLocalDateTime();
                switch (configuration.frequency) {
                    case ONE_TIME: {
                        ITrigger trigger;
                        throwable3 = null;
                        Throwable throwable6 = null;
                        try {
                            trigger = triggers.create(ITrigger.Type.TIME).asTimeTrigger();
                            try {
                                trigger.setStartBoundary(startBoundary);
                                break;
                            }
                            finally {
                                if (trigger != null) {
                                    trigger.close();
                                }
                            }
                        }
                        catch (Throwable throwable7) {
                            if (throwable3 == null) {
                                throwable3 = throwable7;
                            } else if (throwable3 != throwable7) {
                                throwable3.addSuppressed(throwable7);
                            }
                            throw throwable3;
                        }
                    }
                    case MINUTELY: {
                        ITrigger trigger;
                        Throwable throwable8 = null;
                        Throwable throwable6 = null;
                        try {
                            trigger = triggers.create(ITrigger.Type.TIME).asTimeTrigger();
                            try {
                                trigger.setStartBoundary(startBoundary);
                                trigger.getRepetition().setInterval(Duration.ofMinutes(configuration.recurrence));
                                break;
                            }
                            finally {
                                if (trigger != null) {
                                    trigger.close();
                                }
                            }
                        }
                        catch (Throwable throwable9) {
                            if (throwable8 == null) {
                                throwable8 = throwable9;
                            } else if (throwable8 != throwable9) {
                                throwable8.addSuppressed(throwable9);
                            }
                            throw throwable8;
                        }
                    }
                    case HOURLY: {
                        ITrigger trigger;
                        Throwable throwable10 = null;
                        Throwable throwable6 = null;
                        try {
                            trigger = triggers.create(ITrigger.Type.TIME).asTimeTrigger();
                            try {
                                trigger.setStartBoundary(startBoundary);
                                trigger.getRepetition().setInterval(Duration.ofHours(configuration.recurrence));
                                break;
                            }
                            finally {
                                if (trigger != null) {
                                    trigger.close();
                                }
                            }
                        }
                        catch (Throwable throwable11) {
                            if (throwable10 == null) {
                                throwable10 = throwable11;
                            } else if (throwable10 != throwable11) {
                                throwable10.addSuppressed(throwable11);
                            }
                            throw throwable10;
                        }
                    }
                    case DAILY: {
                        ITrigger trigger;
                        Throwable throwable12 = null;
                        Throwable throwable6 = null;
                        try {
                            trigger = triggers.create(ITrigger.Type.DAILY).asDailyTrigger();
                            try {
                                trigger.setStartBoundary(startBoundary);
                                ((IDailyTrigger)trigger).setDaysInterval(configuration.recurrence);
                                break;
                            }
                            finally {
                                if (trigger != null) {
                                    trigger.close();
                                }
                            }
                        }
                        catch (Throwable throwable13) {
                            if (throwable12 == null) {
                                throwable12 = throwable13;
                            } else if (throwable12 != throwable13) {
                                throwable12.addSuppressed(throwable13);
                            }
                            throw throwable12;
                        }
                    }
                    case WEEKLY: {
                        List daysOfWeek = configuration.days.stream().map(x -> TaskDayOfWeek.values()[x - 1]).collect(Collectors.toList());
                        Throwable throwable6 = null;
                        ITrigger trigger = null;
                        try (IWeeklyTrigger trigger2 = triggers.create(ITrigger.Type.WEEKLY).asWeeklyTrigger();){
                            trigger2.setStartBoundary(startBoundary);
                            trigger2.setDaysOfWeek(EnumSet.copyOf(daysOfWeek));
                            trigger2.setWeeksInterval(configuration.recurrence);
                            break;
                        }
                        catch (Throwable trigger22) {
                            if (throwable6 == null) {
                                throwable6 = trigger22;
                            } else if (throwable6 != trigger22) {
                                throwable6.addSuppressed(trigger22);
                            }
                            throw throwable6;
                        }
                    }
                    case MONTHLY: {
                        boolean isLastDay = configuration.days.stream().anyMatch(x -> x == 32);
                        List daysOfMonths = configuration.days.stream().filter(x -> x != 32).map(x -> TaskDayOfMonth.values()[x - 1]).collect(Collectors.toList());
                        List monthsOfYear = configuration.months.stream().map(x -> TaskMonthOfYear.values()[x]).collect(Collectors.toList());
                        Object object = null;
                        Object var14_45 = null;
                        try (IMonthlyTrigger trigger = triggers.create(ITrigger.Type.MONTHLY).asMonthlyTrigger();){
                            trigger.setStartBoundary(startBoundary);
                            trigger.setDaysOfMonth(isLastDay && daysOfMonths.isEmpty() ? EnumSet.noneOf(TaskDayOfMonth.class) : EnumSet.copyOf(daysOfMonths));
                            trigger.setMonthsOfYear(EnumSet.copyOf(monthsOfYear));
                            trigger.setRunOnLastDayOfMonth(isLastDay);
                            break;
                        }
                        catch (Throwable throwable14) {
                            if (object == null) {
                                object = throwable14;
                            } else if (object != throwable14) {
                                ((Throwable)object).addSuppressed(throwable14);
                            }
                            throw object;
                        }
                    }
                    default: {
                        log.error((Object)("Unsupported schedule frequency: " + configuration.frequency));
                        break;
                    }
                }
            }
            catch (Throwable throwable15) {
                if (throwable4 == null) {
                    throwable4 = throwable15;
                } else if (throwable4 != throwable15) {
                    throwable4.addSuppressed(throwable15);
                }
                throw throwable4;
            }
            throwable4 = null;
            var7_14 = null;
            try (IActionCollection actions = definition.getActions();){
                throwable2 = null;
                throwable3 = null;
                try (IActionExecute executeAction = actions.create(IAction.Type.EXECUTE).asExecuteAction();){
                    executeAction.setPath(System.getProperty("eclipse.launcher"));
                    executeAction.setArguments("-runTask \"" + COMSystemScheduler.getRunTaskParameter(task) + "\" -nosplash");
                }
                catch (Throwable throwable16) {
                    if (throwable2 == null) {
                        throwable2 = throwable16;
                    } else if (throwable2 != throwable16) {
                        throwable2.addSuppressed(throwable16);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable17) {
                if (throwable4 == null) {
                    throwable4 = throwable17;
                } else if (throwable4 != throwable17) {
                    throwable4.addSuppressed(throwable17);
                }
                throw throwable4;
            }
            try {
                throwable4 = null;
                var7_14 = null;
                try (ITaskFolder tasksFolder = this.getTasksFolder();){
                    throwable2 = null;
                    throwable3 = null;
                    try (ICollection<IRegisteredTask> registeredTasks = tasksFolder.getTasks();){
                        for (IRegisteredTask registeredTask : registeredTasks) {
                            String nameOrId = COMSystemScheduler.getTaskNameOrId(registeredTask);
                            if (!nameOrId.equals(task.getName()) && !nameOrId.equals(task.getId())) continue;
                            tasksFolder.deleteTask(registeredTask.getName());
                            break;
                        }
                    }
                    catch (Throwable throwable18) {
                        if (throwable2 == null) {
                            throwable2 = throwable18;
                        } else if (throwable2 != throwable18) {
                            throwable2.addSuppressed(throwable18);
                        }
                        throw throwable2;
                    }
                    tasksFolder.registerTask("\\" + COMSystemScheduler.getUniqueTaskName(task), definition, EnumSet.of(TaskCreationFlags.CREATE, TaskCreationFlags.UPDATE), null, null, TaskLogon.INTERACTIVE_TOKEN, "").release();
                }
                catch (Throwable throwable19) {
                    if (throwable4 == null) {
                        throwable4 = throwable19;
                    } else if (throwable4 != throwable19) {
                        throwable4.addSuppressed(throwable19);
                    }
                    throw throwable4;
                }
            }
            catch (COMException e) {
                throw new DBException("Error registering task", (Throwable)e);
            }
        }
        catch (Throwable throwable20) {
            if (throwable == null) {
                throwable = throwable20;
            } else if (throwable != throwable20) {
                throwable.addSuppressed(throwable20);
            }
            throw throwable;
        }
    }

    public void removeTaskSchedule(@NotNull DBTTask task, DBTTaskScheduleInfo scheduleInfo) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ITaskFolder folder = this.getTasksFolder();){
            Throwable throwable2 = null;
            Object var7_10 = null;
            try (IRegisteredTask registeredTask = COMSystemScheduler.findRegisteredTask(folder, task);){
                if (registeredTask != null) {
                    folder.deleteTask(registeredTask.getName());
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public void refreshScheduledTasks(@NotNull DBRProgressMonitor monitor) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ITaskFolder folder = this.getTasksFolder();){
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (ICollection<IRegisteredTask> registeredTasks = folder.getTasks();){
                LinkedHashMap<String, GenericTaskScheduleInfo> tasks = new LinkedHashMap<String, GenericTaskScheduleInfo>();
                for (IRegisteredTask task : registeredTasks) {
                    String nameOrId = COMSystemScheduler.getTaskNameOrId(task);
                    GenericTaskScheduleInfo info = new GenericTaskScheduleInfo(nameOrId, COMSystemScheduler.formatNextRunTime(task.getNextRunTime()), task.getState().toString());
                    tasks.put(nameOrId, info);
                    task.release();
                }
                this.registeredTasks.clear();
                this.registeredTasks.putAll(tasks);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Nullable
    public DBTSchedulerExternalSettings openSchedulerSettings() throws DBException {
        RuntimeUtils.executeProcess((String)"cmd.exe", (String[])new String[]{"/C", "start", "taskschd.msc"});
        return null;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private ITaskFolder getTasksFolder() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 3[TRYBLOCK], 1[TRYBLOCK]], but top level block is 12[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    private static IRegisteredTask findRegisteredTask(@NotNull ITaskFolder folder, @NotNull DBTTask task) {
        var2_2 = null;
        var3_4 = null;
        try {
            tasks = folder.getTasks();
            try {
                var6_7 = tasks.iterator();
                while (true) {
                    registeredTask = var6_7.next();
                    nameOrId = COMSystemScheduler.getTaskNameOrId(registeredTask);
                    if (task.getName().equals(nameOrId) || task.getId().equals(nameOrId)) {
                        return registeredTask;
                    }
                    registeredTask.release();
                    break;
                }
            }
            finally {
                if (var6_7.hasNext()) ** continue;
            }
        }
        catch (Throwable var3_5) {
            if (var2_2 == null) {
                var2_2 = var3_5;
            } else if (var2_2 != var3_5) {
                var2_2.addSuppressed(var3_5);
            }
            throw var2_2;
        }
        return null;
    }

    @NotNull
    private static String formatNextRunTime(@Nullable LocalDateTime nextRunTime) {
        if (nextRunTime == null) {
            return "N/A";
        }
        return DATE_TIME_FORMATTER.format(nextRunTime);
    }

    @NotNull
    private static String getUniqueTaskName(@NotNull DBTTask task) {
        return String.format("%s (%s)", task.getName().replaceAll("\\|/|:|\\*|\\?|\"|<|>|\\|", "\ufffd"), task.getId());
    }

    @NotNull
    private static String getTaskNameOrId(@NotNull IRegisteredTask task) {
        String name = task.getName();
        Matcher matcher = TASK_NAME_PATTERN.matcher(name);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return name;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$dbeaver$model$win32$com$trigger$ITrigger$Type() {
        if ($SWITCH_TABLE$com$dbeaver$model$win32$com$trigger$ITrigger$Type != null) {
            return $SWITCH_TABLE$com$dbeaver$model$win32$com$trigger$ITrigger$Type;
        }
        int[] nArray = new int[ITrigger.Type.values().length];
        try {
            nArray[ITrigger.Type.DAILY.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ITrigger.Type.MONTHLY.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ITrigger.Type.TIME.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ITrigger.Type.WEEKLY.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$dbeaver$model$win32$com$trigger$ITrigger$Type = nArray;
        return nArray;
    }

    private static /* synthetic */ Short lambda$0(TaskDayOfWeek x) {
        return (short)(x.ordinal() + 1);
    }

    private static /* synthetic */ Short lambda$1(TaskDayOfMonth x) {
        return (short)(x.ordinal() + 1);
    }

    private static /* synthetic */ Short lambda$2(TaskMonthOfYear x) {
        return (short)x.ordinal();
    }
}

