/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.sched.system;

import com.dbeaver.ee.sched.system.BaseSystemScheduler;
import com.dbeaver.ee.sched.system.cron.CronSystemScheduler;
import com.dbeaver.ee.sched.system.win.COMSystemScheduler;
import com.dbeaver.ee.sched.system.win.WinSystemScheduler;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.task.DBTScheduler;
import org.jkiss.dbeaver.model.task.DBTSchedulerExternalSettings;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleConfiguration;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleInfo;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class SystemScheduler
implements DBTScheduler {
    private static final String USE_LEGACY_WINDOWS_SCHEDULER = System.getProperty("dbeaver.scheduler.windows.legacy");
    private final BaseSystemScheduler impl = RuntimeUtils.isWindows() ? (CommonUtils.toBoolean((Object)USE_LEGACY_WINDOWS_SCHEDULER) ? new WinSystemScheduler() : new COMSystemScheduler()) : new CronSystemScheduler();

    @NotNull
    public String getSchedulerName() {
        return this.impl.getSchedulerName();
    }

    public boolean supportsFeature(String feature) {
        return this.impl.supportsFeature(feature);
    }

    public DBTScheduler.RecurrenceType getRecurrenceType() {
        return this.impl.getRecurrenceType();
    }

    @NotNull
    public List<DBTTaskScheduleInfo> getAllScheduledTasks() {
        return this.impl.getAllScheduledTasks();
    }

    @Nullable
    public DBTTaskScheduleInfo getScheduledTaskInfo(@NotNull DBTTask task) {
        return this.impl.getScheduledTaskInfo(task);
    }

    @Nullable
    public DBTTaskScheduleConfiguration getScheduledTaskConfiguration(@NotNull DBTTask task) throws DBException {
        return this.impl.getScheduledTaskConfiguration(task);
    }

    public void setTaskSchedule(@NotNull DBTTask task, @NotNull DBTTaskScheduleConfiguration scheduleConfiguration) throws DBException {
        this.impl.setTaskSchedule(task, scheduleConfiguration);
    }

    public void removeTaskSchedule(@NotNull DBTTask task, DBTTaskScheduleInfo scheduleInfo) throws DBException {
        this.impl.removeTaskSchedule(task, scheduleInfo);
    }

    public void refreshScheduledTasks(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.impl.refreshScheduledTasks(monitor);
    }

    public DBTSchedulerExternalSettings openSchedulerSettings() throws DBException {
        return this.impl.openSchedulerSettings();
    }
}

