/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.erd.ui.command;

import com.dbeaver.ee.erd.ui.model.ERDEditUtils;
import org.eclipse.gef3.commands.Command;
import org.jkiss.dbeaver.erd.ui.model.ERDDatabaseObjectModifyCommand;
import org.jkiss.dbeaver.erd.ui.part.AttributePart;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class AttributeRenameCommand
extends Command
implements ERDDatabaseObjectModifyCommand {
    private AttributePart attributePart;
    private String newText;
    private String oldText;

    public AttributeRenameCommand(AttributePart attributePart, String newText) {
        super("Set attribute name");
        this.attributePart = attributePart;
        this.oldText = this.attributePart.getName();
        this.newText = newText;
    }

    public void execute() {
        this.renameAttribute(this.newText);
    }

    public void undo() {
        this.renameAttribute(this.oldText);
        this.attributePart.getFigure().updateLabels();
    }

    private boolean renameAttribute(String newName) {
        if (CommonUtils.equalObjects((Object)this.attributePart.getAttribute().getName(), (Object)newName)) {
            return false;
        }
        DBECommandContext commandContext = this.attributePart.getCommandContext();
        if (commandContext == null) {
            return false;
        }
        return ERDEditUtils.renameDatabaseObject(commandContext, (DBSObject)this.attributePart.getAttribute().getObject(), newName, this.attributePart.getEditor());
    }

    public DBSObject getDatabaseObject() {
        return (DBSObject)this.attributePart.getAttribute().getObject();
    }
}

