/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.grant.addgrant;

import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.grant.AbstractObjectPermissionChange;
import liquibase.ext.ora.grant.addgrant.GrantObjectPermissionStatement;
import liquibase.ext.ora.grant.revokegrant.RevokeObjectPermissionChange;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="grantObjectPermission", description="Grant Schema Object Permission", priority=201)
public class GrantObjectPermissionChange
extends AbstractObjectPermissionChange {
    private Boolean grantOption = Boolean.FALSE;

    public GrantObjectPermissionChange() {
    }

    public GrantObjectPermissionChange(AbstractObjectPermissionChange other) {
        super(other);
    }

    public Boolean getGrantOption() {
        return this.grantOption;
    }

    public void setGrantOption(Boolean grantOption) {
        this.grantOption = grantOption;
    }

    public SqlStatement[] generateStatements(Database database) {
        String schemaName = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
        GrantObjectPermissionStatement statement = new GrantObjectPermissionStatement(schemaName, this.getObjectName(), this.getRecipientList());
        statement.setSelect(this.getSelect());
        statement.setUpdate(this.getUpdate());
        statement.setInsert(this.getInsert());
        statement.setDelete(this.getDelete());
        statement.setExecute(this.getExecute());
        statement.setReferences(this.getReferences());
        statement.setIndex(this.getIndex());
        statement.setGrantOption(this.getGrantOption());
        return new SqlStatement[]{statement};
    }

    @Override
    public String getConfirmationMessage() {
        return "Grants on " + this.getObjectName() + " have been given to " + this.getRecipientList();
    }

    protected Change[] createInverses() {
        RevokeObjectPermissionChange inverse = new RevokeObjectPermissionChange(this);
        return new Change[]{inverse};
    }
}

