/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.enableconstraint;

import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.ext.ora.enableconstraint.EnableConstraintStatement;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Table;

public class EnableConstraintGenerator
extends AbstractSqlGenerator<EnableConstraintStatement> {
    public Sql[] generateSql(EnableConstraintStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ").append(database.escapeTableName(null, statement.getSchemaName(), statement.getTableName())).append(" ENABLE CONSTRAINT ");
        sql.append(database.escapeObjectName(statement.getConstraintName(), Table.class));
        return new Sql[]{new UnparsedSql(sql.toString(), new DatabaseObject[0])};
    }

    public boolean supports(EnableConstraintStatement statement, Database database) {
        return database instanceof OracleDatabase;
    }

    public ValidationErrors validate(EnableConstraintStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validation = new ValidationErrors();
        validation.checkRequiredField("tableName", (Object)statement.getTableName());
        validation.checkRequiredField("constraintName", (Object)statement.getConstraintName());
        return validation;
    }
}

