/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.model.tasks;

import com.dbeaver.ee.scmp.impl.liquibase.LBUtils;
import com.dbeaver.ee.scmp.model.CMPCompareEngine;
import com.dbeaver.ee.scmp.model.CMPOptions;
import com.dbeaver.ee.scmp.model.CMPResult;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskHandler;
import org.jkiss.dbeaver.model.task.DBTTaskRunStatus;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class SCMPTaskHandler
implements DBTTaskHandler {
    @NotNull
    public DBTTaskRunStatus executeTask(@NotNull DBRRunnableContext runnableContext, @NotNull DBTTask task, @NotNull Locale locale, @NotNull Log log, @NotNull PrintStream logStream, @NotNull DBTTaskExecutionListener listener) {
        CMPOptions options = new CMPOptions(false);
        options.loadConfiguration(runnableContext, task.getProperties());
        try {
            runnableContext.run(true, true, monitor -> {
                CMPResult cmpResult;
                Exception error;
                block17: {
                    DBPDataSourceContainer sourceContainer = options.getSourceDataSourceContainer();
                    DBPDataSourceContainer targetContainer = options.getTargetDataSourceContainer();
                    if (sourceContainer == null || targetContainer == null) {
                        DBWorkbench.getPlatformUI().showError("Schema Compare", "Containers for comparison are missing");
                        return;
                    }
                    List<DBSObject> sourceInputObjects = options.getSourceInputObjects();
                    List<DBSObject> targetInputObjects = options.getTargetInputObjects();
                    if (sourceInputObjects.isEmpty() || targetInputObjects.isEmpty()) {
                        DBWorkbench.getPlatformUI().showError("Schema Compare", "There are no objects for comparison");
                        return;
                    }
                    monitor.beginTask("Compare '" + DBUtils.getObjectFullName((DBPNamedObject)sourceContainer, (DBPEvaluationContext)DBPEvaluationContext.UI) + "' <-> '" + DBUtils.getObjectFullName((DBPNamedObject)targetContainer, (DBPEvaluationContext)DBPEvaluationContext.UI) + "'", 100);
                    Log.setLogWriter((OutputStream)logStream);
                    listener.taskStarted(task);
                    error = null;
                    cmpResult = null;
                    try {
                        try {
                            Throwable throwable = null;
                            Object var13_15 = null;
                            try (CMPCompareEngine engine = LBUtils.createDiffEngine(options);){
                                monitor.beginTask("Perform diff using engine...", 10);
                                monitor.subTask("Prepare");
                                cmpResult = engine.compareObjects(monitor, options);
                                if (options.isExportFile() && cmpResult != null) {
                                    LBUtils.createAndExportReportFile(monitor, options, cmpResult);
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception e) {
                            error = e;
                            log.debug((Object)"Can't compare objects", (Throwable)e);
                            monitor.done();
                            Log.setLogWriter(null);
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        monitor.done();
                        Log.setLogWriter(null);
                        throw throwable;
                    }
                    monitor.done();
                    Log.setLogWriter(null);
                }
                listener.taskFinished(task, cmpResult, (Throwable)error, (Object)options);
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Schema Compare", "Error comparing metadata", e.getTargetException());
        }
        catch (InterruptedException e) {
            log.debug((Object)"Canceled by user", (Throwable)e);
        }
        return new DBTTaskRunStatus();
    }
}

