/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.impl.liquibase;

import com.dbeaver.ee.scmp.model.CMPCompareEngine;
import com.dbeaver.ee.scmp.model.CMPOptions;
import com.dbeaver.ee.scmp.model.CMPReportEngine;
import com.dbeaver.ee.scmp.model.CMPResult;
import com.dbeaver.ee.scmp.registry.SCMPDiffEngineDescriptor;
import com.dbeaver.ee.scmp.registry.SCMPEngineRegistry;
import com.dbeaver.ee.scmp.registry.SCMPReportEngineDescriptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import liquibase.diff.compare.CompareControl;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class LBUtils {
    private static final Log log = Log.getLog(LBUtils.class);
    public static final String VARIABLE_PROJECT = "project";
    public static final String VARIABLE_DATASOURCE = "datasource";
    public static final String VARIABLE_HOST = "host";
    public static final String VARIABLE_DATABASE = "database";
    public static final String VARIABLE_SCHEMA = "schema";
    private static final String VARIABLE_DATE = "date";
    private static final String VARIABLE_TIMESTAMP = "timestamp";
    private static final String VARIABLE_YEAR = "year";
    private static final String VARIABLE_MONTH = "month";
    private static final String VARIABLE_DAY = "day";
    public static final String[] ALL_VARIABLES = new String[]{"project", "datasource", "host", "database", "schema", "date", "timestamp", "year", "month", "day"};

    public static String getTargetSchema(CompareControl control, String sourceSchema) {
        CompareControl.SchemaComparison[] schemaComparisonArray = control.getSchemaComparisons();
        int n = schemaComparisonArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompareControl.SchemaComparison sc = schemaComparisonArray[n2];
            if (sc.getReferenceSchema() != null) {
                if (sc.getReferenceSchema().getSchemaName() != null && sc.getReferenceSchema().getSchemaName().equalsIgnoreCase(sourceSchema)) {
                    return sc.getComparisonSchema().getSchemaName();
                }
                if (sc.getReferenceSchema().getCatalogName() != null && sc.getReferenceSchema().getCatalogName().equalsIgnoreCase(sourceSchema)) {
                    return sc.getComparisonSchema().getCatalogName();
                }
            }
            ++n2;
        }
        return null;
    }

    public static CMPCompareEngine createDiffEngine(@NotNull CMPOptions options) {
        SCMPDiffEngineDescriptor diffEngineDescriptor = null;
        if (!CommonUtils.isEmpty((String)options.getDiffEngineId()) && (diffEngineDescriptor = SCMPEngineRegistry.getInstance().getDiffEngine(options.getDiffEngineId())) == null) {
            log.warn((Object)("Diff engine '" + options.getDiffEngineId() + "' not found. Use default."));
        }
        if (diffEngineDescriptor == null) {
            diffEngineDescriptor = SCMPEngineRegistry.getInstance().getDefaultDiffEngine();
        }
        CMPCompareEngine diffEngine = null;
        try {
            diffEngine = diffEngineDescriptor.createEngine();
        }
        catch (DBException e) {
            log.debug((Object)"Can't create comparison engine", (Throwable)e);
        }
        return diffEngine;
    }

    @NotNull
    public static String replaceVariables(@NotNull String name) {
        switch (name) {
            case "timestamp": {
                return RuntimeUtils.getCurrentTimeStamp();
            }
            case "date": {
                return RuntimeUtils.getCurrentDate();
            }
            case "year": {
                return new SimpleDateFormat("yyyy").format(new Date());
            }
            case "month": {
                return new SimpleDateFormat("MM").format(new Date());
            }
            case "day": {
                return new SimpleDateFormat("dd").format(new Date());
            }
        }
        return System.getProperty(name);
    }

    public static Path createReportFile(@NotNull SCMPReportEngineDescriptor engine) throws IOException {
        Path tempFolder = DBWorkbench.getPlatform().getTempFolder((DBRProgressMonitor)new VoidProgressMonitor(), "scmp-diff-reports");
        return tempFolder.resolve("diff-report-" + engine.getId() + "-" + new SimpleDateFormat("yyyyMMddHHmmss").format(System.currentTimeMillis()) + "." + engine.getFileExtension());
    }

    public static void createAndExportReportFile(@NotNull DBRProgressMonitor monitor, @NotNull CMPOptions options, @NotNull CMPResult cmpResult) throws DBException, IOException {
        SCMPReportEngineDescriptor descriptor = SCMPEngineRegistry.getInstance().getReportEngine(options.getReportEngineId());
        CMPReportEngine reportEngine = descriptor.createEngine();
        Path reportFile = LBUtils.createReportFile(descriptor);
        monitor.subTask("Generate report");
        Throwable throwable = null;
        Object var7_8 = null;
        try (OutputStream os = Files.newOutputStream(reportFile, new OpenOption[0]);){
            reportEngine.generateDiffReport(monitor, cmpResult, os);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        LBUtils.exportReportFile(options.getOutputFile(), reportFile);
    }

    public static void exportReportFile(@NotNull File targetFile, @NotNull Path reportFile) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream is = Files.newInputStream(reportFile, new OpenOption[0]);){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (FileOutputStream os = new FileOutputStream(targetFile);){
                    IOUtils.fastCopy((InputStream)is, (OutputStream)os);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e1) {
            DBWorkbench.getPlatformUI().showError("Save error", "Error saving report to file", (Throwable)e1);
        }
    }

    public static String getSourceSchema(CompareControl control, String targetSchema) {
        CompareControl.SchemaComparison[] schemaComparisonArray = control.getSchemaComparisons();
        int n = schemaComparisonArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompareControl.SchemaComparison sc = schemaComparisonArray[n2];
            if (sc.getReferenceSchema() != null) {
                if (sc.getComparisonSchema().getSchemaName() != null && sc.getComparisonSchema().getSchemaName().equalsIgnoreCase(targetSchema)) {
                    return sc.getReferenceSchema().getSchemaName();
                }
                if (sc.getComparisonSchema().getCatalogName() != null && sc.getComparisonSchema().getCatalogName().equalsIgnoreCase(targetSchema)) {
                    return sc.getReferenceSchema().getCatalogName();
                }
            }
            ++n2;
        }
        return null;
    }

    public static String getSourceCatalog(CompareControl control, String targetCatalog) {
        CompareControl.SchemaComparison[] schemaComparisonArray = control.getSchemaComparisons();
        int n = schemaComparisonArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompareControl.SchemaComparison sc = schemaComparisonArray[n2];
            if (sc.getReferenceSchema() != null && sc.getComparisonSchema().getCatalogName() != null && sc.getComparisonSchema().getCatalogName().equalsIgnoreCase(targetCatalog)) {
                return sc.getReferenceSchema().getCatalogName();
            }
            ++n2;
        }
        return null;
    }
}

