/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redis.exec;

import com.dbeaver.db.redis.exec.RedisBaseResultSet;
import com.dbeaver.db.redis.exec.RedisBaseStatement;
import com.dbeaver.db.redis.exec.RedisSession;
import com.dbeaver.db.redis.model.RedisKeyType;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import redis.clients.jedis.commands.JedisCommands;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.resps.ScanResult;
import redis.clients.jedis.resps.Tuple;

public class RedisResultSetCursor
extends RedisBaseResultSet {
    private static final Log log = Log.getLog(RedisResultSetCursor.class);
    private String keyName;
    private RedisKeyType keyType;
    private String cursorId = "0";
    private ScanResult scanResult;
    private int scanPosition = -1;

    public RedisResultSetCursor(RedisBaseStatement statement, String keyName, RedisKeyType keyType) {
        super(statement);
        this.keyName = keyName;
        this.keyType = keyType;
    }

    public Object getAttributeValue(int index) throws DBCException {
        Object row = this.scanResult.getResult().get(this.scanPosition);
        switch (this.keyType) {
            case set: {
                if (index != 0) break;
                return row;
            }
            case hash: {
                if (index == 0) {
                    return ((Map.Entry)row).getKey();
                }
                if (index != 1) break;
                return ((Map.Entry)row).getValue();
            }
            case zset: {
                if (index == 0) {
                    return ((Tuple)row).getScore();
                }
                if (index != 1) break;
                return ((Tuple)row).getElement();
            }
        }
        throw new DBCException("Bad attribute index: " + index);
    }

    public Object getAttributeValue(String name) throws DBCException {
        Object row = this.scanResult.getResult().get(this.scanPosition);
        switch (this.keyType) {
            case set: {
                if (!"value".equals(name)) break;
                return row;
            }
            case hash: {
                if ("name".equals(name)) {
                    return ((Map.Entry)row).getKey();
                }
                if (!"value".equals(name)) break;
                return ((Map.Entry)row).getValue();
            }
            case zset: {
                if ("score".equals(name)) {
                    return ((Tuple)row).getScore();
                }
                if (!"value".equals(name)) break;
                return ((Tuple)row).getElement();
            }
        }
        throw new DBCException("Bad attribute name: '" + name + "'");
    }

    public boolean nextRow() throws DBCException {
        if (this.scanResult == null || this.scanPosition >= this.scanResult.getResult().size()) {
            boolean endOfCursor;
            this.scanResult = null;
            this.scanPosition = -1;
            this.cursorId.equals("0");
            do {
                this.nextScan();
                boolean bl = endOfCursor = this.scanResult == null || this.scanResult.getCursor().equals("0");
            } while (!endOfCursor && this.scanResult.getResult().isEmpty());
        }
        if (this.scanResult == null) {
            return false;
        }
        ++this.scanPosition;
        if (this.scanPosition >= this.scanResult.getResult().size()) {
            return false;
        }
        ++this.rowNumber;
        return true;
    }

    private void nextScan() throws DBCException {
        block9: {
            try {
                if (((RedisSession)this.session).supportsCommands(JedisCommands.class)) {
                    JedisCommands jedis = ((RedisSession)this.session).getCommands(JedisCommands.class);
                    ScanParams scanParams = new ScanParams();
                    if (((RedisBaseStatement)this.statement).getLimit() > 0L) {
                        scanParams.count(Integer.valueOf((int)((RedisBaseStatement)this.statement).getLimit()));
                    }
                    switch (this.keyType) {
                        case set: {
                            this.scanResult = jedis.sscan(this.keyName, this.cursorId, scanParams);
                            break block9;
                        }
                        case hash: {
                            this.scanResult = jedis.hscan(this.keyName, this.cursorId, scanParams);
                            break block9;
                        }
                        case zset: {
                            this.scanResult = jedis.zscan(this.keyName, this.cursorId, scanParams);
                            break block9;
                        }
                        default: {
                            throw new DBCException("Unsupported key type: " + (Object)((Object)this.keyType));
                        }
                    }
                }
                throw new DBCException("Cursors are not supported by server");
            }
            catch (Exception e) {
                throw new DBCException("Error scanning key '" + this.keyName + "' as " + (Object)((Object)this.keyType), (Throwable)e);
            }
        }
        this.cursorId = this.scanResult.getCursor();
    }

    public boolean moveTo(int position) throws DBCException {
        throw new DBCException("Scrolling not supported");
    }

    @Override
    protected void fillMetaData(List<DBCAttributeMetaData> attributes) {
        if (this.keyType == RedisKeyType.set) {
            attributes.add(new RedisBaseResultSet.OutputAttribute("value", 0, 1, DBPDataKind.OBJECT));
        } else if (this.keyType == RedisKeyType.zset) {
            attributes.add(new RedisBaseResultSet.OutputAttribute("score", 0, 2, DBPDataKind.NUMERIC));
            attributes.add(new RedisBaseResultSet.OutputAttribute("value", 1, 1, DBPDataKind.OBJECT));
        } else {
            attributes.add(new RedisBaseResultSet.OutputAttribute("name", 0, 1, DBPDataKind.STRING));
            attributes.add(new RedisBaseResultSet.OutputAttribute("value", 1, 1, DBPDataKind.OBJECT));
        }
    }
}

