/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor.panel;

import com.dbeaver.ee.vqb.internal.ui.VQBMessages;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPresentation;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQueryElements;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQuerySelectItems;
import com.dbeaver.model.sql.vqb.builder.VQBQueryInfo;
import com.dbeaver.model.sql.vqb.model.ERDJoin;
import com.dbeaver.model.sql.vqb.model.VQBJoinType;
import com.dbeaver.model.sql.vqb.model.VQBUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDAssociation;
import org.jkiss.dbeaver.erd.model.ERDDiagram;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomComboBoxCellEditor;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.utils.CommonUtils;

class VQBPanelQueryJoins
extends VQBPanelQueryElements<Object> {
    private static final Log log = Log.getLog(VQBPanelQuerySelectItems.class);

    protected VQBPanelQueryJoins(VQBEditorPresentation presentation) {
        super(presentation);
    }

    @Override
    protected TreeContentProvider makeContentProvider() {
        return new TreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Join) {
                    return this.getChildren(inputElement);
                }
                return super.getElements(inputElement);
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof Join) {
                    Expression conditions = VQBPanelQueryJoins.this.getJoinConditions((Join)parentElement);
                    if (conditions == null) {
                        return null;
                    }
                    ArrayList<Expression> result = new ArrayList<Expression>();
                    if (VQBUtils.isCompoundExpression((Expression)conditions)) {
                        VQBUtils.collectNestedConditions((VQBQueryInfo)VQBPanelQueryJoins.this.getQueryInfo(), result, (Expression)conditions, (Expression)conditions);
                    } else {
                        result.add(conditions);
                    }
                    return result.toArray();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof Join) {
                    return VQBPanelQueryJoins.this.getJoinConditions((Join)element) != null;
                }
                return false;
            }
        };
    }

    @Override
    protected void loadElements() {
        SelectBody selectBody = this.getQueryInfo().getParsedQuery().getSelectBody();
        if (selectBody instanceof PlainSelect) {
            this.elementViewer.setInput((Object)((PlainSelect)selectBody).getJoins());
        } else {
            this.elementViewer.setInput(new ArrayList(0));
        }
        this.elementViewer.expandAll();
    }

    @Override
    protected void fillColumns(ViewerColumnController<Object, Object> columnsController) {
        super.fillColumns(columnsController);
        columnsController.addColumn(VQBMessages.editor_panel_joins_columns_join_conditions_name, VQBMessages.editor_panel_joins_columns_join_conditions_description, 16384, true, true, item -> {
            if (item instanceof Join) {
                FromItem rightItem = ((Join)item).getRightItem();
                if (rightItem instanceof Table) {
                    return ((Table)rightItem).getFullyQualifiedName();
                }
            } else if (item instanceof Expression) {
                return item.toString();
            }
            return null;
        }, null);
        EditingSupport typeEditingSupport = new EditingSupport((ColumnViewer)this.elementViewer){

            protected CellEditor getCellEditor(Object element) {
                CustomComboBoxCellEditor editor = new CustomComboBoxCellEditor((ColumnViewer)VQBPanelQueryJoins.this.elementViewer, (Composite)VQBPanelQueryJoins.this.elementViewer.getTree(), new String[0], 12);
                VQBJoinType[] types = VQBJoinType.values();
                ArrayList<String> typeNames = new ArrayList<String>();
                VQBJoinType[] vQBJoinTypeArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    VQBJoinType type = vQBJoinTypeArray[n2];
                    if (type.isSupported()) {
                        typeNames.add(type.getName());
                    }
                    ++n2;
                }
                editor.setItems(typeNames.toArray(new String[typeNames.size()]));
                return editor;
            }

            protected boolean canEdit(Object element) {
                return element instanceof Join;
            }

            protected Object getValue(Object element) {
                if (element instanceof Join) {
                    return VQBJoinType.getByJoin((Join)((Join)element)).getName();
                }
                return null;
            }

            protected void setValue(Object element, Object value) {
                VQBJoinType newType;
                VQBJoinType oldType;
                if (element instanceof Join && (oldType = VQBJoinType.getByJoin((Join)((Join)element))) != (newType = VQBJoinType.getByName((String)((String)value)))) {
                    newType.setJoinType((Join)element);
                    VQBPanelQueryJoins.this.refreshDiagramAndStatement();
                }
            }
        };
        columnsController.addColumn(VQBMessages.editor_panel_joins_columns_join_type_name, VQBMessages.editor_panel_joins_columns_join_type_description, 16384, true, true, item -> {
            if (item instanceof Join) {
                return VQBJoinType.getByJoin((Join)((Join)item)).getName();
            }
            return null;
        }, typeEditingSupport);
        VQBPanelQueryElements.TextEditingSupport<Object> aliasEditingSupport = new VQBPanelQueryElements.TextEditingSupport<Object>((VQBPanelQueryElements)this){

            @Override
            protected boolean canEdit(Object element) {
                return element instanceof Join;
            }

            @Override
            protected String convertExpressionToString(Object join) {
                if (join instanceof Join) {
                    Alias alias = ((Join)join).getRightItem().getAlias();
                    return alias == null ? "" : alias.getName();
                }
                return null;
            }

            @Override
            protected void updateElementText(Object join, String text) {
                if (join instanceof Join) {
                    Alias alias;
                    Alias alias2 = alias = CommonUtils.isEmpty((String)text) ? null : new Alias(text);
                    if (((Join)join).getRightItem() instanceof Table) {
                        VQBUtils.updateTableAlias((VQBQueryInfo)VQBPanelQueryJoins.this.getQueryInfo(), (Table)((Table)((Join)join).getRightItem()), (Alias)alias);
                    }
                }
            }
        };
        columnsController.addColumn(VQBMessages.editor_panel_joins_columns_alias_name, VQBMessages.editor_panel_joins_columns_alias_description, 16384, true, true, item -> {
            if (item instanceof Join) {
                Alias alias = ((Join)item).getRightItem().getAlias();
                return alias == null ? null : alias.getName();
            }
            return null;
        }, (EditingSupport)aliasEditingSupport);
    }

    @Override
    protected void fillPanelContributions(IContributionManager contributionManager) {
        super.fillPanelContributions(contributionManager);
        contributionManager.add((IAction)new Action(VQBMessages.editor_panel_select_items_action_remove, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ROW_DELETE)){

            public void run() {
                ERDJoin erdJoin;
                PlainSelect plainSelect = VQBPanelQueryJoins.this.getPlainSelect();
                if (plainSelect == null) {
                    log.error((Object)"No plain select. Cannot remove condition.");
                    return;
                }
                List joins = plainSelect.getJoins();
                if (joins.isEmpty()) {
                    log.error((Object)"No JOINs detected. Cannot remove condition.");
                    return;
                }
                Object selectedElement = VQBPanelQueryJoins.this.getSelectedElement();
                if (selectedElement instanceof Expression) {
                    for (Join join : joins) {
                        Expression onExpression = VQBUtils.getJoinOnExpression((Join)join);
                        if (!VQBUtils.isPartOf((Expression)((Expression)selectedElement), (Expression)onExpression)) continue;
                        ERDJoin erdJoin2 = VQBUtils.findERDJoin((ERDDiagram)VQBPanelQueryJoins.this.presentation.getVQBEditor().getDiagram(), (Join)join);
                        join.setOnExpressions(Collections.emptyList());
                        if (erdJoin2 == null) continue;
                        UIUtils.syncExec(() -> {
                            erdJoin2.getTargetEntity().removeReferenceAssociation((ERDAssociation)erdJoin2, true);
                            erdJoin2.getSourceEntity().removeAssociation((ERDAssociation)erdJoin2, true);
                        });
                    }
                }
                if (selectedElement instanceof Join && (erdJoin = VQBUtils.findERDJoin((ERDDiagram)VQBPanelQueryJoins.this.presentation.getVQBEditor().getDiagram(), (Join)((Join)selectedElement))) != null) {
                    UIUtils.syncExec(() -> {
                        erdJoin.getTargetEntity().removeReferenceAssociation((ERDAssociation)erdJoin, true);
                        erdJoin.getSourceEntity().removeAssociation((ERDAssociation)erdJoin, true);
                    });
                    joins.remove(selectedElement);
                }
                VQBPanelQueryJoins.this.refreshDiagramAndStatement();
            }

            public boolean isEnabled() {
                return VQBPanelQueryJoins.this.getSelectedElement() instanceof Expression || VQBPanelQueryJoins.this.getSelectedElement() instanceof Join;
            }
        });
    }

    @Override
    protected DBIcon getDefaultIcon() {
        return null;
    }

    private Expression getJoinConditions(Join join) {
        if (join.isSimple()) {
            return null;
        }
        return VQBUtils.getJoinOnExpression((Join)join);
    }
}

