/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.azure;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.subscription.SubscriptionManager;
import com.azure.resourcemanager.subscription.models.Subscription;
import com.azure.resourcemanager.subscription.models.TenantIdDescription;
import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.InteractiveRequestParameters;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.aad.msal4j.SilentParameters;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.meta.SecureProperty;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import reactor.core.publisher.Mono;

public class AuthModelAzureCredentials
extends AuthModelDatabaseNativeCredentials {
    private String clientId;
    @SecureProperty
    private PublicClientApplication application;
    @SecureProperty
    private String tenantId;
    @SecureProperty
    private String subscriptionId;
    @SecureProperty
    private final Map<Resource, String> resourceTokens = new HashMap<Resource, String>();

    public AuthModelAzureCredentials() {
    }

    public AuthModelAzureCredentials(@NotNull AuthModelAzureCredentials other) {
        this.clientId = other.clientId;
        this.application = other.application;
        this.tenantId = other.tenantId;
        this.subscriptionId = other.subscriptionId;
        this.resourceTokens.putAll(other.resourceTokens);
    }

    @NotNull
    public <T> T authenticate(@NotNull DBRProgressMonitor monitor, @NotNull Resource resource, @NotNull BiFunction<TokenCredential, AzureProfile, T> factory) throws DBException {
        String token = this.getResourceToken(monitor, resource);
        TokenCredential credential = request -> Mono.just((Object)new AccessToken(token, OffsetDateTime.MAX));
        AzureProfile profile = this.acquireProfile(monitor, credential);
        return factory.apply(credential, profile);
    }

    @NotNull
    public synchronized String getResourceToken(@NotNull DBRProgressMonitor monitor, @NotNull Resource resource) throws DBException {
        String token = this.getResourceToken(resource);
        if (token == null) {
            if (this.application == null) {
                this.application = PublicClientApplication.builder((String)this.clientId).build();
            }
            try {
                try {
                    Set accounts = (Set)this.application.getAccounts().get();
                    CompletableFuture request = accounts.isEmpty() ? this.application.acquireToken(InteractiveRequestParameters.builder((URI)URI.create("http://localhost")).scopes(resource.scopes).build()) : this.application.acquireTokenSilently(SilentParameters.builder(resource.scopes, (IAccount)((IAccount)accounts.iterator().next())).build());
                    monitor.beginTask("Acquire token", 1);
                    token = ((IAuthenticationResult)request.get()).accessToken();
                    this.setResourceToken(token, resource);
                }
                catch (Exception e) {
                    throw new DBException("Error acquiring token", (Throwable)e);
                }
            }
            finally {
                monitor.worked(1);
                monitor.done();
            }
        }
        return token;
    }

    @Nullable
    public String getResourceToken(@NotNull Resource resource) {
        return this.resourceTokens.get((Object)resource);
    }

    public void setResourceToken(@NotNull String accessToken, @NotNull Resource resource) {
        this.resourceTokens.put(resource, accessToken);
    }

    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(@NotNull String clientId) {
        this.clientId = clientId;
        this.application = null;
        this.tenantId = null;
        this.subscriptionId = null;
        this.resourceTokens.clear();
    }

    public String getUserName() {
        return super.getUserName();
    }

    public String getUserPassword() {
        return super.getUserPassword();
    }

    @NotNull
    private synchronized AzureProfile acquireProfile(@NotNull DBRProgressMonitor monitor, @NotNull TokenCredential credential) {
        if (this.tenantId == null || this.subscriptionId == null) {
            SubscriptionManager manager = SubscriptionManager.authenticate((TokenCredential)credential, (AzureProfile)new AzureProfile(AzureEnvironment.AZURE));
            try {
                monitor.beginTask("Acquire Azure profile", 2);
                monitor.subTask("Retrieve information about subscriptions");
                this.subscriptionId = ((Subscription)manager.subscriptions().list().stream().findFirst().orElseThrow(() -> new IllegalStateException("Can't find subscription"))).subscriptionId();
                monitor.worked(1);
                monitor.subTask("Retrieve information about tenants");
                this.tenantId = ((TenantIdDescription)manager.tenants().list().stream().findFirst().orElseThrow(() -> new IllegalStateException("Can't find tenant"))).tenantId();
                monitor.worked(1);
            }
            finally {
                monitor.done();
            }
        }
        return new AzureProfile(this.tenantId, this.subscriptionId, AzureEnvironment.AZURE);
    }

    public static enum Resource {
        MANAGEMENT("https://management.azure.com//.default"),
        DATABASE("https://database.windows.net//.default");

        private final Set<String> scopes;

        private Resource(String ... scopes) {
            this.scopes = Set.of(scopes);
        }
    }
}

