/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.figures;

import org.eclipse.draw2dl.Graphics;
import org.eclipse.draw2dl.Label;
import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.draw2dl.geometry.Insets;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.draw2dl.geometry.Translatable;
import org.jkiss.dbeaver.ui.UIUtils;

public class EditableLabel
extends Label {
    private boolean selected;

    public EditableLabel(String text) {
        super(text);
    }

    private Rectangle getSelectionRectangle() {
        Rectangle bounds = this.getTextBounds().getCopy();
        bounds.expand(new Insets(2, 2, 0, 0));
        this.translateToParent((Translatable)bounds);
        bounds.intersect(this.getBounds());
        return bounds;
    }

    public void setText(String s) {
        super.setText(s);
    }

    protected void paintFigure(Graphics graphics) {
        if (this.selected) {
            graphics.pushState();
            graphics.setBackgroundColor(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.attributes.foreground"));
            graphics.fillRoundRectangle(this.getSelectionRectangle(), 3, 3);
            graphics.popState();
            graphics.setForegroundColor(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.background"));
        }
        super.paintFigure(graphics);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return super.getPreferredSize(wHint, hHint);
    }

    public void setSelected(boolean b) {
        this.selected = b;
        this.repaint();
    }
}

